/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.Call;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CallsUpdatedEvent {
    long handle;

    CallsUpdatedEvent(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_calls_updated_event_args_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_calls_updated_event_args_release(this.handle));
        this.handle = 0L;
    }

    public List<Call> getAddedCalls() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_calls_updated_event_args_get_added_calls(this.handle, result, result_length));
        ArrayList<Call> resultList = new ArrayList<Call>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(ProjectedObjectCache.getOrCreate(resultArray[i], ModelClass.Call, Call.class, true));
        }
        List<Call> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    public List<Call> getRemovedCalls() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_calls_updated_event_args_get_removed_calls(this.handle, result, result_length));
        ArrayList<Call> resultList = new ArrayList<Call>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(ProjectedObjectCache.getOrCreate(resultArray[i], ModelClass.Call, Call.class, true));
        }
        List<Call> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }
}

