/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.IdentifierHelpers;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.common.CommunicationIdentifier;

public final class CallerInfo {
    long handle;

    CallerInfo(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_caller_info_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_caller_info_release(this.handle));
        this.handle = 0L;
    }

    public String getDisplayName() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_caller_info_get_display_name(this.handle, result));
        return (String)result.value;
    }

    private String getCallerIdentifier() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_caller_info_get_caller_identifier(this.handle, result));
        return (String)result.value;
    }

    public CommunicationIdentifier getIdentifier() {
        return IdentifierHelpers.from(this.getCallerIdentifier());
    }
}

