/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.EmergencyCallOptions;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.status;

public final class CallAgentOptions {
    long handle;

    CallAgentOptions(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_call_agent_options_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public CallAgentOptions() {
        Out<Long> result_handle = new Out<Long>();
        status resultStatus = NativeLibrary.sam_call_agent_options_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_options_release(this.handle));
        this.handle = 0L;
    }

    public String getDisplayName() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_options_get_display_name(this.handle, result));
        return (String)result.value;
    }

    public CallAgentOptions setDisplayName(String value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_options_set_display_name(this.handle, value));
        return this;
    }

    public EmergencyCallOptions getEmergencyCallOptions() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_options_get_emergency_call_options(this.handle, result_handle));
        EmergencyCallOptions result_object = (Long)result_handle.value != 0L ? ProjectedObjectCache.getOrCreate((Long)result_handle.value, ModelClass.EmergencyCallOptions, EmergencyCallOptions.class, true) : null;
        return result_object;
    }

    public CallAgentOptions setEmergencyCallOptions(EmergencyCallOptions value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_options_set_emergency_call_options(this.handle, value_converted));
        return this;
    }
}

