/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.status;

public final class AudioOptions {
    long handle;

    AudioOptions(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_audio_options_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public AudioOptions() {
        Out<Long> result_handle = new Out<Long>();
        status resultStatus = NativeLibrary.sam_audio_options_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_audio_options_release(this.handle));
        this.handle = 0L;
    }

    public boolean isMuted() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_audio_options_get_muted(this.handle, result));
        return (Boolean)result.value;
    }

    public AudioOptions setMuted(boolean value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_audio_options_set_muted(this.handle, value));
        return this;
    }
}

