/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.IdentifierHelpers;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.status;
import com.azure.android.communication.common.CommunicationIdentifier;
import com.azure.android.communication.common.PhoneNumberIdentifier;

public final class AddPhoneNumberOptions {
    long handle;

    AddPhoneNumberOptions(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_add_phone_number_options_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public AddPhoneNumberOptions() {
        Out<Long> result_handle = new Out<Long>();
        status resultStatus = NativeLibrary.sam_add_phone_number_options_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_add_phone_number_options_release(this.handle));
        this.handle = 0L;
    }

    private String getAlternateId() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_add_phone_number_options_get_alternate_id(this.handle, result));
        return (String)result.value;
    }

    private AddPhoneNumberOptions setAlternateId(String value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_add_phone_number_options_set_alternate_id(this.handle, value));
        return this;
    }

    public AddPhoneNumberOptions(PhoneNumberIdentifier alternatePhoneNumber) {
        this();
        this.setAlternateId(IdentifierHelpers.toMRI((CommunicationIdentifier)alternatePhoneNumber));
    }

    public AddPhoneNumberOptions setAlternateCallerId(PhoneNumberIdentifier alternatePhoneNumber) {
        this.setAlternateId(IdentifierHelpers.toMRI((CommunicationIdentifier)alternatePhoneNumber));
        return this;
    }

    public PhoneNumberIdentifier getAlternateCallerId() {
        return (PhoneNumberIdentifier)IdentifierHelpers.from(this.getAlternateId());
    }
}

