/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.codec.encoder.camera.gl;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.view.Surface;
import com.skype.android.video.hw.codec.encoder.camera.gl.Context;
import com.skype.android.video.hw.codec.encoder.camera.gl.EGLUtils;
import com.skype.android.video.hw.codec.encoder.camera.gl.GLException;
import com.skype.android.video.hw.codec.encoder.camera.gl.Program;
import com.skype.android.video.hw.codec.encoder.camera.gl.SurfaceTextureRenderer;
import com.skype.android.video.hw.format.Resolution;
import com.skype.android.video.hw.utils.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class VirtualSourceGenerator {
    private final Object surfaceMutex = new Object();
    private Surface surface;
    private EGLSurface eglSurface;
    private Program glProgram;
    private MVPMatrix mvpMatrix;
    private int textureId;
    private TriangleVertices triangleVertices;
    private EGLDisplay eglDisplay;
    private EGLSurface dummySurface;
    private Resolution sourceResolution;
    private Resolution targetResolution;
    private static String simpleClassName = VirtualSourceGenerator.class.getSimpleName();
    private static final int[] EGL_CONTEXT_ATTRIBUTES = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 0, 12326, 0, 12344};
    private Context sharedContext;
    private Context context;
    private static final String VERTEX_SHADER = "uniform mat4 uMVPMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = aTextureCoord.xy;\n}\n";
    private static final String PIXEL_SHADER = "precision mediump float;\nvarying vec2 vTextureCoord;\nuniform sampler2D sTexture;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";

    public void setup() throws GLException {
        this.createEGLDisplay();
        this.sharedContext = new Context(this.eglDisplay, EGL_CONTEXT_ATTRIBUTES);
        int[] attributes = new int[]{12375, 640, 12374, 480, 12344};
        this.dummySurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.sharedContext.getEGLDisplay(), (EGLConfig)this.sharedContext.getEGLConfig(), (int[])attributes, (int)0);
        EGL14.eglMakeCurrent((EGLDisplay)this.sharedContext.getEGLDisplay(), (EGLSurface)this.dummySurface, (EGLSurface)this.dummySurface, (EGLContext)this.sharedContext.getEGLContext());
        this.glProgram = new Program(VERTEX_SHADER, PIXEL_SHADER);
        this.mvpMatrix = new MVPMatrix(this.glProgram);
        this.triangleVertices = new TriangleVertices(this.glProgram);
        this.textureId = this.createTexture();
        GLES20.glClearColor((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        GLES20.glDisable((int)2929);
        GLES20.glEnable((int)3553);
        EGL14.eglMakeCurrent((EGLDisplay)this.sharedContext.getEGLDisplay(), (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
    }

    public void close() throws GLException {
        if (this.glProgram != null) {
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", simpleClassName + ": Closing");
            }
            this.glProgram.close();
            this.glProgram = null;
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", simpleClassName + ": Closed");
            }
        }
    }

    public void setResolution(Resolution resolution) {
        this.sourceResolution = resolution;
        this.targetResolution = resolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSurface(Surface s) {
        Object object = this.surfaceMutex;
        synchronized (object) {
            if (this.surface != null) {
                this.surface.release();
            }
            this.surface = s;
        }
    }

    private void createEGLDisplay() throws GLException {
        int[] eglVersion;
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", simpleClassName + ": Creating EGL display");
        }
        this.eglDisplay = EGL14.eglGetDisplay((int)0);
        if (this.eglDisplay == EGL14.EGL_NO_DISPLAY) {
            throw new GLException("Failed to get EGL14 display.", EGL14.eglGetError());
        }
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", simpleClassName + ": Initializing EGL");
        }
        if (!EGL14.eglInitialize((EGLDisplay)this.eglDisplay, (int[])(eglVersion = new int[2]), (int)0, (int[])eglVersion, (int)1)) {
            throw new GLException("Failed to initialize EGL.", EGL14.eglGetError());
        }
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", simpleClassName + ": EGL initialized: version " + eglVersion[0] + "." + eglVersion[1]);
        }
    }

    private static void bindTexture(int textureId) throws GLException {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", simpleClassName + ": Binding texture " + textureId);
        }
        GLES20.glBindTexture((int)3553, (int)textureId);
        VirtualSourceGenerator.validate("Failed to bind texture ", textureId);
    }

    private static void validate(Object ... msgStringSeq) throws GLException {
        int error = GLES20.glGetError();
        if (error != 0) {
            throw new GLException(VirtualSourceGenerator.cat(msgStringSeq), error);
        }
    }

    private static String cat(Object ... seq) {
        StringBuilder str = new StringBuilder();
        for (Object o : seq) {
            str.append(o);
        }
        return str.toString();
    }

    public void createContextIfNotExist() throws GLException {
        if (this.context == null) {
            this.context = new Context(this.sharedContext, EGL_CONTEXT_ATTRIBUTES);
            int[] attributes = new int[]{12344};
            this.eglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.context.getEGLDisplay(), (EGLConfig)this.context.getEGLConfig(), (Object)this.surface, (int[])attributes, (int)0);
        }
    }

    private int createTexture() throws GLException {
        int[] textureHandle = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureHandle, (int)0);
        if (textureHandle[0] == 0) {
            throw new RuntimeException("Error loading texture.");
        }
        return textureHandle[0];
    }

    private static void setViewPort(Resolution resolution) throws GLException {
        int y = (16 - resolution.getHeight() % 16) % 16;
        GLES20.glScissor((int)0, (int)y, (int)resolution.getWidth(), (int)resolution.getHeight());
        VirtualSourceGenerator.validate("Failed to set scissor to ", resolution);
        GLES20.glViewport((int)0, (int)y, (int)resolution.getWidth(), (int)resolution.getHeight());
        VirtualSourceGenerator.validate("Failed to set viewport to ", resolution);
    }

    private void loadTexture(Resolution sourceResolution, int textureId, ByteBuffer frameData) {
        GLES20.glBindTexture((int)3553, (int)textureId);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9728);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9728);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)sourceResolution.getWidth(), (int)sourceResolution.getHeight(), (int)0, (int)6408, (int)5121, (Buffer)frameData);
        frameData.position(0);
    }

    public void renderOneFrame(ByteBuffer frameData, long timestamp) throws GLException {
        this.createContextIfNotExist();
        EGL14.eglMakeCurrent((EGLDisplay)this.context.getEGLDisplay(), (EGLSurface)this.eglSurface, (EGLSurface)this.eglSurface, (EGLContext)this.context.getEGLContext());
        VirtualSourceGenerator.validate("Failed to eglMakeCurrent");
        this.loadTexture(this.sourceResolution, this.textureId, frameData);
        this.mvpMatrix.makeIdentity();
        this.mvpMatrix.transform(this.sourceResolution, this.targetResolution, 0, false, true);
        this.triangleVertices.setup();
        VirtualSourceGenerator.setViewPort(this.targetResolution);
        VirtualSourceGenerator.validate("Failed to set uViewport to ", this.targetResolution);
        this.render();
        VirtualSourceGenerator.bindTexture(0);
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", simpleClassName + ".draw() leave");
        }
        if (timestamp < 0L && Log.isLoggable("SLIQ", 6)) {
            Log.e("SLIQ", "Provided timestamp is negative but must be positive for MediaCodec: " + timestamp);
        }
        EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.context.getEGLDisplay(), (EGLSurface)this.eglSurface, (long)(timestamp * 1000L));
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", SurfaceTextureRenderer.class.getSimpleName() + ": current frame surface timestamp " + timestamp * 1000L + " ns");
        }
        EGL14.eglSwapBuffers((EGLDisplay)this.context.getEGLDisplay(), (EGLSurface)this.eglSurface);
        EGLUtils.validate("Failed to swap buffers.");
    }

    private void render() throws GLException {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", SurfaceTextureRenderer.class.getSimpleName() + ": rendering a frame");
        }
        GLES20.glClear((int)16384);
        this.glProgram.install();
        int textureUniformHandle = this.glProgram.getUniformLocation("sTexture");
        GLES20.glUniform1i((int)textureUniformHandle, (int)0);
        this.mvpMatrix.setup();
        GLES20.glActiveTexture((int)33984);
        VirtualSourceGenerator.bindTexture(this.textureId);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        VirtualSourceGenerator.validate("Failed to draw arrays");
    }

    private static class TriangleVertices {
        private static final int FLOAT_SIZE_BYTES = 4;
        private static final int TRIANGLE_VERTICES_DATA_STRIDE_BYTES = 20;
        private static final int TRIANGLE_VERTICES_DATA_POS_OFFSET = 0;
        private static final int TRIANGLE_VERTICES_DATA_UV_OFFSET = 3;
        private static final float[] triangleVerticesData = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
        private final FloatBuffer data = ByteBuffer.allocateDirect(triangleVerticesData.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        private final int idxDataPosOffset;
        private final int idxDataUVOffset;

        public TriangleVertices(Program glProgram) throws GLException {
            this.data.put(triangleVerticesData).position(0);
            this.idxDataPosOffset = glProgram.getAttribLocation("aPosition");
            this.idxDataUVOffset = glProgram.getAttribLocation("aTextureCoord");
        }

        private void setupVertexAttrib(int pos, int index, int size) throws GLException {
            this.data.position(pos);
            GLES20.glVertexAttribPointer((int)index, (int)size, (int)5126, (boolean)false, (int)20, (Buffer)this.data);
            VirtualSourceGenerator.validate(new Object[]{"Failed to define vertex attribute data"});
            GLES20.glEnableVertexAttribArray((int)index);
            VirtualSourceGenerator.validate(new Object[]{"Failed to enable vertex attribute array"});
        }

        public void setup() throws GLException {
            this.setupVertexAttrib(0, this.idxDataPosOffset, 3);
            this.setupVertexAttrib(3, this.idxDataUVOffset, 2);
        }
    }

    private static class MVPMatrix
    extends AbstractUniformMatrix {
        private static final float AR_COMPARISON_TOLERANCE = 0.01f;

        public MVPMatrix(Program glProgram) throws GLException {
            super(glProgram, "uMVPMatrix");
        }

        public void transform(Resolution sourceResolution, Resolution targetResolution, int rotationAngle, boolean isHorizFlipped, boolean isVertFlipped) {
            float sourceAR;
            boolean isPortrait = MVPMatrix.isPortrait(rotationAngle);
            float targetAR = MVPMatrix.getAR(targetResolution, isPortrait);
            if (Math.abs(targetAR - (sourceAR = MVPMatrix.getAR(sourceResolution, false))) > 0.01f) {
                float scaleX = 1.0f;
                float scaleY = 1.0f;
                if (targetAR < sourceAR) {
                    if (isPortrait) {
                        scaleY = targetAR;
                    } else {
                        scaleX = targetAR;
                    }
                } else if (isPortrait) {
                    scaleX = sourceAR;
                } else {
                    scaleY = sourceAR;
                }
                Matrix.scaleM((float[])this.data, (int)0, (float)scaleX, (float)scaleY, (float)1.0f);
            }
            if (isHorizFlipped || isVertFlipped) {
                Matrix.scaleM((float[])this.data, (int)0, (float)(isHorizFlipped ? -1.0f : 1.0f), (float)(isVertFlipped ? -1.0f : 1.0f), (float)1.0f);
            }
            Matrix.rotateM((float[])this.data, (int)0, (float)rotationAngle, (float)0.0f, (float)0.0f, (float)1.0f);
        }

        private static boolean isPortrait(int angle) {
            return angle % 180 != 0;
        }

        private static float getAR(Resolution resolution, boolean swapDimensions) {
            return swapDimensions ? (float)resolution.getHeight() / (float)resolution.getWidth() : (float)resolution.getWidth() / (float)resolution.getHeight();
        }
    }

    private static abstract class AbstractUniformMatrix {
        protected final float[] data = new float[16];
        private final int idx;

        public AbstractUniformMatrix(Program glProgram, String varName) throws GLException {
            this.idx = glProgram.getUniformLocation(varName);
        }

        public void makeIdentity() {
            Matrix.setIdentityM((float[])this.data, (int)0);
        }

        public void setup() throws GLException {
            GLES20.glUniformMatrix4fv((int)this.idx, (int)1, (boolean)false, (float[])this.data, (int)0);
            VirtualSourceGenerator.validate(new Object[]{"Failed to setup matrix"});
        }
    }
}

