/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.codec.encoder.camera.capture;

import android.graphics.SurfaceTexture;
import com.skype.android.video.hw.codec.encoder.camera.SurfaceObserver;
import com.skype.android.video.hw.codec.encoder.camera.capture.CameraCapturerSource;
import com.skype.android.video.hw.codec.encoder.camera.capture.CapturerException;
import com.skype.android.video.hw.codec.encoder.camera.capture.CapturerParameters;
import com.skype.android.video.hw.codec.encoder.camera.capture.CapturerSinks;
import com.skype.android.video.hw.codec.encoder.camera.capture.CapturerSource;
import com.skype.android.video.hw.codec.encoder.camera.gl.GLException;
import com.skype.android.video.hw.codec.encoder.camera.gl.SurfaceTextureChannel;
import com.skype.android.video.hw.format.Resolution;
import com.skype.android.video.hw.utils.Log;
import com.skype.android.video.hw.utils.Systrace;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeoutException;

public class Capturer {
    private final CapturerSinks sinks = new CapturerSinks();
    private final Object sinkMutex = new Object();
    protected CapturerSource captureSource;
    private SurfaceTextureChannel channel;
    private Resolution cameraResolution;
    private Runner runner;
    private Thread runnerThread;
    private volatile boolean isStarted;
    private static String simpleClassName = Capturer.class.getSimpleName();

    public synchronized Sink addPreviewSink(SinkEvents cb) {
        return this.sinks.addPreviewSink(this.sinkMutex, cb);
    }

    public synchronized Sink addEncoderSink(SinkEvents cb) {
        return this.sinks.addEncoderSink(this.sinkMutex, cb, this.channel);
    }

    public synchronized void removeSink(Sink sink) {
        this.sinks.removeSink(sink);
    }

    public synchronized void closeSinks() {
        this.sinks.close();
    }

    public synchronized void setCameraResolution(Resolution resolution) throws CapturerException {
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", simpleClassName + ": Switching camera to " + resolution);
        }
        boolean wasStarted = this.isStarted;
        if (this.isStarted) {
            this.stop();
        }
        this.captureSource.setResolution(resolution);
        this.channel.setInputResolution(resolution);
        if (wasStarted) {
            this.start();
        }
    }

    public synchronized void setCameraFramerate(float framerate) throws CapturerException {
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", simpleClassName + ": Switching camera to " + framerate + " fps");
        }
        boolean wasStarted = this.isStarted;
        if (this.isStarted) {
            this.stop();
        }
        this.captureSource.setFramerate((int)(framerate * 1000.0f));
        if (wasStarted) {
            this.start();
        }
    }

    public synchronized void setCameraParameters(Resolution resolution, float framerate) throws CapturerException {
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", simpleClassName + ": Switching camera to " + (resolution != null ? resolution : "") + (framerate > 0.0f ? "@" + framerate + " fps" : ""));
        }
        boolean wasStarted = this.isStarted;
        if (this.isStarted) {
            this.stop();
        }
        this.captureSource.configure(resolution, framerate > 0.0f ? (int)(framerate * 1000.0f) : 0);
        if (resolution != null) {
            this.channel.setInputResolution(resolution);
        }
        if (wasStarted) {
            this.start();
        }
    }

    public synchronized void initialize(CapturerParameters capturerParameters, RunnerEvents cb) {
        if (this.isAlive()) {
            throw new IllegalStateException("already running");
        }
        this.runner = new Runner(capturerParameters, cb);
        this.runnerThread = new Thread((Runnable)this.runner, Capturer.class.getCanonicalName());
        this.runnerThread.start();
    }

    public synchronized void terminate(long timeoutMs) throws InterruptedException {
        if (this.isStarted) {
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", simpleClassName + ": Stopping capture source");
            }
            this.stop();
        }
        if (this.isAlive()) {
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", simpleClassName + ": Shutting down the runner");
            }
            this.runner.close();
            this.channel.interrupt();
            this.runnerThread.join(timeoutMs);
        }
        if (this.isAlive() && Log.isLoggable("SLIQ", 5)) {
            Log.w("SLIQ", simpleClassName + ": Runner thead did not exit in " + timeoutMs + " ms");
        }
    }

    public synchronized boolean isAlive() {
        return this.runnerThread != null && this.runnerThread.isAlive();
    }

    public synchronized void start() throws CapturerException {
        if (this.captureSource == null) {
            throw new IllegalStateException("closed");
        }
        if (!this.isStarted) {
            this.captureSource.start();
            this.isStarted = true;
        }
    }

    public synchronized void stop() {
        if (this.captureSource == null) {
            throw new IllegalStateException("closed");
        }
        if (this.isStarted) {
            this.captureSource.stop();
            this.isStarted = false;
        }
    }

    public boolean isStarted() {
        return this.isAlive() && this.isStarted;
    }

    protected long doOverrideFrameTimestamp(long timestamp) {
        return timestamp;
    }

    protected CapturerSource doCreateCapturerSource(CapturerParameters capturerParameters) throws CapturerException {
        return new CameraCapturerSource(capturerParameters.cameraId);
    }

    protected void setup(CapturerParameters capturerParameters) throws CapturerException, GLException {
        try {
            this.cameraResolution = capturerParameters.cameraResolution;
            try {
                this.channel = new SurfaceTextureChannel(capturerParameters.isPreEncodingRC){

                    protected long getTimestamp(SurfaceTexture st) {
                        return Capturer.this.doOverrideFrameTimestamp(st.getTimestamp());
                    }
                };
                this.sinks.syncWith(this.channel);
                this.sinks.setChannel(this.channel);
            }
            catch (GLException e) {
                throw new CapturerException("Failed to create SurfaceTextureChannel", e);
            }
            this.channel.setInputResolution(this.cameraResolution);
            this.captureSource = this.doCreateCapturerSource(capturerParameters);
            this.captureSource.configure(capturerParameters.cameraResolution, (int)(capturerParameters.framerate * 1000.0f));
            this.captureSource.setSurfaceTexture(this.channel.getInput());
            this.channel.freeContext();
        }
        catch (CapturerException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", simpleClassName + ": Initialization failed. Closing");
            }
            this.shutdown();
            throw e;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", simpleClassName + ": Initialization failed. Closing");
            }
            this.shutdown();
            throw e;
        }
        catch (GLException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", simpleClassName + ": Initialization failed. Closing");
            }
            this.shutdown();
            throw e;
        }
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", simpleClassName + ": Initialized");
        }
    }

    private void shutdown() {
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", simpleClassName + ": Closing");
        }
        if (this.captureSource != null) {
            try {
                this.captureSource.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.captureSource = null;
        }
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", simpleClassName + ": Closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareNextFrame(long timeoutMs) throws CapturerException, InterruptedException, TimeoutException {
        if (this.channel == null) {
            throw new IllegalStateException("closed");
        }
        try {
            long timestampNS = this.channel.acquireFrame(timeoutMs);
            long timestampMS = timestampNS / 1000000L;
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", simpleClassName + " Capturer timestampNS " + timestampNS + " timestampMS " + timestampMS);
            }
            Object object = this.sinkMutex;
            synchronized (object) {
                this.sinks.syncWith(this.channel);
                this.channel.pushAndRenderFrame(timestampMS * 1000000L);
            }
        }
        catch (GLException e) {
            throw new CapturerException("Failed to push a frame through SurfaceTextureChannel", e);
        }
        finally {
            Systrace.end();
        }
    }

    private class Runner
    implements Runnable,
    Closeable {
        private static final long CAPTURE_TIMEOUT_MS = Long.MAX_VALUE;
        private final CapturerParameters capturerParameters;
        private final RunnerEvents cb;
        private volatile boolean shallRun = true;
        private String runnerSimpleClassName = Runner.class.getSimpleName();

        public Runner(CapturerParameters capturerParameters, RunnerEvents cb) {
            this.capturerParameters = capturerParameters;
            this.cb = cb;
        }

        public void close() {
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", this.runnerSimpleClassName + ": Requesting exit");
            }
            this.shallRun = false;
        }

        public void run() {
            if (this.capturerParameters == null) {
                throw new IllegalStateException("no capture parameters set");
            }
            try {
                if (Log.isLoggable("SLIQ", 4)) {
                    Log.i("SLIQ", this.runnerSimpleClassName + ": Entering");
                }
                if (Capturer.this.channel == null) {
                    Capturer.this.setup(this.capturerParameters);
                }
                if (this.cb != null) {
                    this.cb.onStarted();
                }
                while (this.shallRun) {
                    Capturer.this.prepareNextFrame(Long.MAX_VALUE);
                }
                Capturer.this.shutdown();
                Capturer.this.isStarted = false;
            }
            catch (RuntimeException e) {
                if (Log.isLoggable("SLIQ", 6)) {
                    Log.e("SLIQ", this.runnerSimpleClassName + ": UnexpectedException caught", e);
                }
                Capturer.this.shutdown();
                Capturer.this.isStarted = false;
                if (this.cb != null) {
                    this.cb.onFailed(e);
                }
            }
            catch (CapturerException e) {
                if (Log.isLoggable("SLIQ", 6)) {
                    Log.e("SLIQ", this.runnerSimpleClassName + ": Capturing has failed", e);
                }
                Capturer.this.shutdown();
                Capturer.this.isStarted = false;
                if (this.cb != null) {
                    this.cb.onFailed(e);
                }
            }
            catch (InterruptedException e) {
                if (Log.isLoggable("SLIQ", 4)) {
                    Log.i("SLIQ", this.runnerSimpleClassName + ": Interrupted");
                }
                Capturer.this.shutdown();
                Capturer.this.isStarted = false;
            }
            catch (TimeoutException e) {
                if (Log.isLoggable("SLIQ", 6)) {
                    Log.e("SLIQ", this.runnerSimpleClassName + ": Timeout expired");
                }
                Capturer.this.shutdown();
                Capturer.this.isStarted = false;
                if (this.cb != null) {
                    this.cb.onFailed(e);
                }
            }
            catch (GLException e) {
                if (Log.isLoggable("SLIQ", 6)) {
                    Log.e("SLIQ", this.runnerSimpleClassName + ": GL Error");
                }
                Capturer.this.shutdown();
                Capturer.this.isStarted = false;
            }
            finally {
                if (this.cb != null) {
                    this.cb.onStopped();
                }
                if (Log.isLoggable("SLIQ", 4)) {
                    Log.i("SLIQ", this.runnerSimpleClassName + ": Leaving");
                }
            }
        }
    }

    public static interface RunnerEvents {
        public void onStarted();

        public void onStopped();

        public void onFailed(Exception var1);
    }

    public static interface SinkEvents {
        public void onFrameCaptured(long var1);
    }

    public static interface Sink
    extends SurfaceObserver {
        public void setResolution(Resolution var1);

        public void setEnabled(boolean var1);

        public void setRotationAngle(int var1);

        public void setFlipped(boolean var1, boolean var2);

        public void setFitFactor(float var1);
    }
}

