/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.jipc;

import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transactor {
    public static final Charset C_STRING_ENCODING = Charset.forName("US-ASCII");
    static final BytePacker packer = new BytePacker(){

        public int pack(byte first, byte second, byte third, byte last) {
            return ((first << 24 >>> 8 | second << 24) >>> 8 | third << 24) >>> 8 | last << 24;
        }
    };
    static final int NO_FLAGS = 0;
    private static final Parcel ruler = Parcel.obtain();

    /*
     * Loose catch block
     */
    public static <T> T transact(IBinder media, What opCode, In argPreparer, Out<T> out) {
        Parcel reply = Parcel.obtain();
        try {
            T t;
            Parcel in = Parcel.obtain();
            try {
                argPreparer.prepare(in);
                media.transact(opCode.code(), in, reply, 0);
                t = out.parse(reply);
            }
            catch (RemoteException re) {
                throw new RuntimeException(re);
            }
            finally {
                in.recycle();
            }
            return t;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString8(Parcel reply, byte[] bytes) {
        int length = reply.readInt();
        if (length == 0) {
            return "";
        }
        int offset = reply.dataPosition();
        try {
            String string = new String(bytes, offset, length, C_STRING_ENCODING);
            return string;
        }
        finally {
            int pos = offset + length + 1;
            reply.setDataPosition(pos);
            Transactor.readAlign32(reply);
        }
    }

    static byte byteOrZero(CharSequence cs, int index, int length) {
        return index < length ? (byte)cs.charAt(index) : (byte)0;
    }

    static byte byteOrZero(byte[] bytes, int index) {
        return index < bytes.length ? bytes[index] : (byte)0;
    }

    public static void writeCString(Parcel in, CharSequence string) {
        int length = string.length();
        int sizeCeil = length + 4 & 0xFFFFFFFC;
        int i = 0;
        while (i < sizeCeil) {
            byte f = Transactor.byteOrZero(string, i++, length);
            byte s = Transactor.byteOrZero(string, i++, length);
            byte t = Transactor.byteOrZero(string, i++, length);
            byte l = Transactor.byteOrZero(string, i++, length);
            in.writeInt(packer.pack(f, s, t, l));
        }
    }

    public static void writeRawBytes(Parcel in, byte[] bytes) {
        int sizeCeil = bytes.length + 3 & 0xFFFFFFFC;
        int i = 0;
        while (i < sizeCeil) {
            byte f = Transactor.byteOrZero(bytes, i++);
            byte s = Transactor.byteOrZero(bytes, i++);
            byte t = Transactor.byteOrZero(bytes, i++);
            byte l = Transactor.byteOrZero(bytes, i++);
            in.writeInt(packer.pack(f, s, t, l));
        }
    }

    private static void readAlign32(Parcel data) {
        int dataPosition = data.dataPosition();
        if ((dataPosition & 3) != 0) {
            data.setDataPosition((dataPosition | 3) + 1);
        }
    }

    private static void writeAlign32(Parcel data) {
        int remainder = data.dataPosition() & 3;
        if (remainder != 0) {
            data.appendFrom(ruler, 0, 4 - remainder);
        }
    }

    static {
        ruler.unmarshall(new byte[4], 0, 4);
    }

    static interface BytePacker {
        public int pack(byte var1, byte var2, byte var3, byte var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Out<T> {
        public T parse(Parcel var1);
    }

    public static interface In {
        public void prepare(Parcel var1);
    }

    public static interface What {
        public int code();
    }
}

