/*
 * Decompiled with CFR 0.152.
 */
package com.ayz4sci.androidfactory.permissionhelper;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.ayz4sci.androidfactory.permissionhelper.PermissionsGroup;
import com.ayz4sci.androidfactory.permissionhelper.R;
import java.util.ArrayList;
import pl.tajchert.nammu.Nammu;
import pl.tajchert.nammu.PermissionCallback;

public class PermissionHelper {
    private static PermissionHelper permissionHelper;
    private static final int REQUEST_CODE = 12345;
    private Dialog permissionDialog;
    private ImageButton backArrow;
    private TextView permissionTitleTextView;
    private TextView permissionDescTextView;
    private Button allowButton;
    private Button notAllowButton;
    private String continueText;
    private String notNowText;
    private String goToAppInfo;
    private String accessMessage;
    private String permissionTitle;
    private String permissionDeniedString;
    private String grantPermissionToString;
    private String enablePermissionFromSettings;
    private String appName;
    private PermissionCallback permissionCallback;
    private ArrayList<String> neededPermissions;
    private Activity activity;

    public static PermissionHelper getInstance(Activity activity) {
        if (permissionHelper == null) {
            Nammu.init((Context)activity);
            permissionHelper = new PermissionHelper(activity);
            return permissionHelper;
        }
        return permissionHelper;
    }

    public PermissionHelper(Activity activity) {
        this.activity = activity;
        this.permissionDialog = new Dialog((Context)activity, 16973829);
        this.permissionDialog.requestWindowFeature(1);
        this.permissionDialog.setCancelable(false);
        this.permissionDialog.setContentView(R.layout.permissions_page);
        this.initUI(this.permissionDialog);
        this.initListeners();
    }

    private void initUI(Dialog dialog) {
        this.backArrow = (ImageButton)dialog.findViewById(R.id.back_arrow);
        this.permissionTitleTextView = (TextView)dialog.findViewById(R.id.permission_title);
        this.permissionDescTextView = (TextView)dialog.findViewById(R.id.permission_description);
        this.allowButton = (Button)dialog.findViewById(R.id.allow_button);
        this.notAllowButton = (Button)dialog.findViewById(R.id.not_now_button);
        this.continueText = dialog.getContext().getString(R.string.continue_text);
        this.notNowText = dialog.getContext().getString(R.string.not_now);
        this.goToAppInfo = dialog.getContext().getString(R.string.go_to_app_info);
        this.accessMessage = dialog.getContext().getString(R.string.access_your);
        this.permissionTitle = dialog.getContext().getString(R.string.permission_title);
        this.permissionDeniedString = dialog.getContext().getString(R.string.permission_denied_title_message);
        this.grantPermissionToString = dialog.getContext().getString(R.string.grant_permission_to);
        this.enablePermissionFromSettings = dialog.getContext().getString(R.string.permission_can_be_enabled_under);
        this.getAppName();
    }

    private void initListeners() {
        this.backArrow.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PermissionHelper.this.permissionDialog.dismiss();
                PermissionHelper.this.permissionCallback.permissionRefused();
            }
        });
        this.allowButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PermissionHelper.this.allowButton.getText().toString().equalsIgnoreCase(PermissionHelper.this.continueText)) {
                    Nammu.askForPermission((Activity)PermissionHelper.this.activity, (String[])PermissionHelper.this.neededPermissions.toArray(new String[PermissionHelper.this.neededPermissions.size()]), (PermissionCallback)new PermissionCallback(){

                        public void permissionGranted() {
                            PermissionHelper.this.permissionDialog.dismiss();
                            PermissionHelper.this.permissionCallback.permissionGranted();
                        }

                        public void permissionRefused() {
                            Nammu.refreshMonitoredList();
                            ArrayList<String> newNeededPermissions = new ArrayList<String>();
                            ArrayList approvedPermissions = Nammu.getGrantedPermissions();
                            for (String neededPermission : PermissionHelper.this.neededPermissions) {
                                if (approvedPermissions.contains(neededPermission)) continue;
                                newNeededPermissions.add(neededPermission);
                            }
                            PermissionHelper.this.permissionFailedMessage(newNeededPermissions.toArray(new String[newNeededPermissions.size()]), "");
                        }
                    });
                } else {
                    PermissionHelper.this.openAppSettings(PermissionHelper.this.activity);
                }
            }
        });
        this.notAllowButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PermissionHelper.this.permissionDialog.dismiss();
                PermissionHelper.this.permissionCallback.permissionRefused();
            }
        });
    }

    protected void showMessage(String title, String[] permissions) {
        this.permissionTitleTextView.setText((CharSequence)String.format(this.permissionTitle, title));
        String permissionList = String.format(this.accessMessage, PermissionsGroup.getPermissionGroupString(permissions[0]).toLowerCase());
        int length = permissions.length;
        for (int i = 1; i < length; ++i) {
            String permissionGroup = PermissionsGroup.getPermissionGroupString(permissions[i]);
            if (permissionList.contains(permissionGroup.toLowerCase())) continue;
            permissionList = permissionList + "\n" + String.format(this.accessMessage, permissionGroup.toLowerCase());
        }
        this.permissionDescTextView.setText((CharSequence)permissionList);
        this.allowButton.setText((CharSequence)this.continueText);
        this.notAllowButton.setText((CharSequence)this.notNowText);
        this.permissionDialog.show();
    }

    protected void permissionFailedMessage(String[] permissions, String title) {
        if (permissions.length > 0) {
            String permissionList = PermissionsGroup.getPermissionGroupString(permissions[0]);
            int length = permissions.length;
            for (int i = 1; i < length; ++i) {
                String permissionGroup = PermissionsGroup.getPermissionGroupString(permissions[i]);
                if (permissionList.contains(permissionGroup)) continue;
                permissionList = permissionList + ", " + permissionGroup;
            }
            if (title.isEmpty()) {
                this.permissionTitleTextView.setText((CharSequence)String.format(this.permissionDeniedString, permissions.length > 1 ? "permissions" : "permission"));
            } else {
                this.permissionTitleTextView.setText((CharSequence)String.format(this.grantPermissionToString, title));
            }
            this.permissionDescTextView.setText((CharSequence)String.format(this.enablePermissionFromSettings, this.appName, permissionList + (permissions.length > 1 ? " permissions" : " permission")));
            this.allowButton.setText((CharSequence)this.goToAppInfo);
            this.permissionDialog.show();
        }
    }

    public void verifyPermission(String[] titles, String[] requiredPermissions, PermissionCallback permissionCallback) {
        if (Build.VERSION.SDK_INT < 23) {
            permissionCallback.permissionGranted();
            return;
        }
        if (titles.length != requiredPermissions.length) {
            throw new IllegalArgumentException("Titles length must be equal to required permissions length");
        }
        this.neededPermissions = new ArrayList();
        this.permissionCallback = permissionCallback;
        ArrayList<String> shouldShowRequestPermissionRationales = new ArrayList<String>();
        String neededPermissionsTitle = "";
        String requestPermissionRationalesTitle = "";
        int length = requiredPermissions.length;
        for (int i = 0; i < length; ++i) {
            String requiredPermission = requiredPermissions[i];
            if (Nammu.checkPermission((String)requiredPermission)) continue;
            this.neededPermissions.add(requiredPermission);
            if (!neededPermissionsTitle.contains(titles[i])) {
                neededPermissionsTitle = neededPermissionsTitle + (this.neededPermissions.size() == 1 ? "" : ", ") + titles[i];
            }
            if (!Nammu.shouldShowRequestPermissionRationale((Activity)this.activity, (String)requiredPermission)) continue;
            shouldShowRequestPermissionRationales.add(requiredPermission);
            if (requestPermissionRationalesTitle.contains(titles[i])) continue;
            requestPermissionRationalesTitle = requestPermissionRationalesTitle + (shouldShowRequestPermissionRationales.size() == 1 ? "" : ", ") + titles[i];
        }
        boolean shouldShowPermissionsPage = false;
        if (!shouldShowRequestPermissionRationales.isEmpty() && shouldShowPermissionsPage) {
            this.permissionFailedMessage(shouldShowRequestPermissionRationales.toArray(new String[shouldShowRequestPermissionRationales.size()]), "");
        } else if (!shouldShowRequestPermissionRationales.isEmpty() && !shouldShowPermissionsPage) {
            this.permissionFailedMessage(shouldShowRequestPermissionRationales.toArray(new String[shouldShowRequestPermissionRationales.size()]), requestPermissionRationalesTitle);
        } else if (!this.neededPermissions.isEmpty()) {
            this.showMessage(neededPermissionsTitle, this.neededPermissions.toArray(new String[this.neededPermissions.size()]));
        } else {
            this.permissionDialog.dismiss();
            permissionCallback.permissionGranted();
        }
    }

    public static void verifyPermissions(String[] requiredPermissions, PermissionCallback permissionCallback) {
        for (String requiredPermission : requiredPermissions) {
            if (Nammu.checkPermission((String)requiredPermission)) continue;
            permissionCallback.permissionRefused();
            return;
        }
        permissionCallback.permissionGranted();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 12345 && this.permissionCallback != null && this.activity != null) {
            ArrayList<String> rejectedPermissions = new ArrayList<String>();
            for (String neededPermission : this.neededPermissions) {
                if (Nammu.checkPermission((String)neededPermission)) continue;
                rejectedPermissions.add(neededPermission);
            }
            this.permissionDialog.dismiss();
            if (!rejectedPermissions.isEmpty()) {
                this.permissionCallback.permissionRefused();
            } else {
                this.permissionCallback.permissionGranted();
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        Nammu.onRequestPermissionsResult((int)requestCode, (String[])permissions, (int[])grantResults);
    }

    public void openAppSettings(Activity activity) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)activity.getPackageName(), null);
        intent.setData(uri);
        activity.startActivityForResult(intent, 12345);
    }

    private void getAppName() {
        PackageManager packageManager = this.permissionDialog.getContext().getPackageManager();
        try {
            this.appName = (String)packageManager.getApplicationLabel(packageManager.getApplicationInfo(this.permissionDialog.getContext().getPackageName(), 128));
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    public Dialog getPermissionDialog() {
        return this.permissionDialog;
    }

    protected void setPermissionCallback(PermissionCallback permissionCallback) {
        this.permissionCallback = permissionCallback;
    }

    protected void setNeededPermissions(ArrayList neededPermissions) {
        this.neededPermissions = neededPermissions;
    }

    public ImageButton getBackButton() {
        return this.backArrow;
    }

    public Button getAllowButton() {
        return this.allowButton;
    }

    public Button getNotAllowButton() {
        return this.notAllowButton;
    }

    public ImageView getCenterIcon() {
        return (ImageView)this.permissionDialog.findViewById(R.id.center_icon);
    }

    public RelativeLayout getBackgroundLayout() {
        return (RelativeLayout)this.permissionDialog.findViewById(R.id.background_layout);
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void customiseUI(int background, Drawable icon) {
        this.getBackgroundLayout().setBackgroundColor(this.activity.getResources().getColor(background));
        this.getCenterIcon().setImageDrawable(icon);
    }

    public void finish() {
        this.permissionDialog.dismiss();
        permissionHelper = null;
    }
}

