/*
 * Decompiled with CFR 0.152.
 */
package com.ayvytr.customview.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitmapUtil {
    private static Bitmap toBitmap1(Drawable drawable) {
        BitmapDrawable bd = (BitmapDrawable)drawable;
        return bd.getBitmap();
    }

    private static Bitmap toBitmap2(Drawable drawable) {
        int w = drawable.getIntrinsicWidth();
        int h = drawable.getIntrinsicHeight();
        Bitmap.Config config = drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, w, h);
        drawable.draw(canvas);
        return bitmap;
    }

    public static Bitmap toBitmap(Drawable drawable) {
        try {
            return BitmapUtil.toBitmap1(drawable);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BitmapUtil.toBitmap2(drawable);
        }
    }

    public static Bitmap toBitmap(byte[] bytes) {
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    public static byte[] toByteArray(Drawable drawable) {
        return BitmapUtil.toByteArray(BitmapUtil.toBitmap(drawable));
    }

    public static byte[] toByteArray(Bitmap bitmap) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)b);
        byte[] bytes = b.toByteArray();
        try {
            b.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytes;
    }
}

