/*
 * Decompiled with CFR 0.152.
 */
package com.axis.system.jenkins.plugins.downstream.yabv;

import com.axis.system.jenkins.plugins.downstream.cache.BuildCache;
import com.axis.system.jenkins.plugins.downstream.tree.Matrix;
import com.axis.system.jenkins.plugins.downstream.tree.TreeLaminator;
import com.axis.system.jenkins.plugins.downstream.yabv.BuildFlowOptions;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import jenkins.model.TransientActionFactory;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class BuildFlowAction
implements Action {
    private final Run target;
    private final BuildFlowOptions buildFlowOptions;

    private BuildFlowAction(Run run) {
        this.target = run;
        this.buildFlowOptions = new BuildFlowOptions();
    }

    private static final TreeLaminator.ChildrenFunction getChildrenFunc() {
        Queue.Item[] items = Queue.getInstance().getItems();
        return build -> {
            ArrayList result = new ArrayList();
            if (build instanceof Run) {
                result.addAll(BuildCache.getCache().getDownstreamBuilds((Run)build));
                result.addAll(BuildCache.getDownstreamQueueItems((Queue.Item[])items, (Run)((Run)build)));
            }
            return result;
        };
    }

    private static Run getRootUpstreamBuild(@Nonnull Run build) {
        Run parentBuild;
        while ((parentBuild = BuildFlowAction.getUpstreamBuild(build)) != null) {
            build = parentBuild;
        }
        return build;
    }

    private static Run getUpstreamBuild(@Nonnull Run build) {
        CauseAction causeAction = (CauseAction)build.getAction(CauseAction.class);
        if (causeAction == null) {
            return null;
        }
        for (Cause cause : causeAction.getCauses()) {
            if (!(cause instanceof Cause.UpstreamCause)) continue;
            Cause.UpstreamCause upstreamCause = (Cause.UpstreamCause)cause;
            Job upstreamJob = (Job)Jenkins.getInstance().getItemByFullName(upstreamCause.getUpstreamProject(), Job.class);
            if (upstreamJob == null || build.getParent() == upstreamJob) continue;
            return upstreamJob.getBuildByNumber(upstreamCause.getUpstreamBuild());
        }
        return null;
    }

    public BuildFlowOptions getBuildFlowOptions() {
        return this.buildFlowOptions;
    }

    @Exported(visibility=1)
    public boolean isAnyBuildOngoing() {
        return this.target != null && BuildFlowAction.isChildrenStillBuilding(BuildFlowAction.getRootUpstreamBuild(this.target), BuildFlowAction.getChildrenFunc());
    }

    private static boolean isChildrenStillBuilding(Object current, TreeLaminator.ChildrenFunction children) {
        Iterator<Object> childIter = children.children(current).iterator();
        if (childIter.hasNext()) {
            Object child = childIter.next();
            if (child instanceof Queue.Item) {
                return true;
            }
            if (child instanceof Run && ((Run)child).isBuilding()) {
                return true;
            }
            return BuildFlowAction.isChildrenStillBuilding(child, children);
        }
        return false;
    }

    @Exported(visibility=1)
    public boolean isCacheRefreshing() {
        return BuildCache.getCache().isCacheRefreshing();
    }

    public boolean shouldDisplayBuildFlow() {
        return this.target != null && (BuildFlowAction.hasUpstreamOrDownstreamBuilds(this.target) || BuildFlowAction.hasUpstreamOrDownstreamBuilds(this.target.getParent().getLastCompletedBuild()) || BuildFlowAction.hasUpstreamOrDownstreamBuilds(this.target.getParent().getLastBuild()));
    }

    public static boolean hasUpstreamOrDownstreamBuilds(Run target) {
        if (target == null) {
            return false;
        }
        return BuildCache.getCache().getDownstreamBuilds(target).size() > 0 || BuildCache.getDownstreamQueueItems((Run)target).size() > 0 || BuildFlowAction.getUpstreamBuild(target) != null;
    }

    public Run getTarget() {
        return this.target;
    }

    public Matrix buildMatrix() {
        if (this.target == null) {
            return new Matrix();
        }
        return TreeLaminator.layoutTree(BuildFlowAction.getRootUpstreamBuild(this.target), BuildFlowAction.getChildrenFunc());
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "yabv";
    }

    public String getIconFileName() {
        return null;
    }

    public void doBuildFlow(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.buildFlowOptions.setShowDurationInfo(Boolean.parseBoolean(req.getParameter("showDurationInfo")));
        this.buildFlowOptions.setShowBuildHistory(Boolean.parseBoolean(req.getParameter("showBuildHistory")));
        rsp.setContentType("text/html;charset=UTF-8");
        req.getView((Object)this, "buildFlow.groovy").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    @Extension(ordinal=1000.0)
    public static class ProjectActionFactory
    extends TransientActionFactory<Job> {
        public Class<Job> type() {
            return Job.class;
        }

        public Collection<? extends Action> createFor(@Nonnull Job target) {
            Run build = target.getLastBuild();
            if (build == null) {
                return Collections.emptyList();
            }
            return Collections.singleton(new BuildFlowAction(build));
        }
    }

    @Extension
    public static class BuildActionFactory
    extends TransientActionFactory<Run> {
        public Class<Run> type() {
            return Run.class;
        }

        public Collection<? extends Action> createFor(Run run) {
            return Collections.singleton(new BuildFlowAction(run));
        }
    }
}

