/*
 * Decompiled with CFR 0.152.
 */
package com.axis.system.jenkins.plugins.downstream.tree;

import com.axis.system.jenkins.plugins.downstream.tree.Matrix;
import java.util.Iterator;

public class TreeLaminator {
    public static <T> Matrix<T> layoutTree(T rootNode, ChildrenFunction<T> children) {
        Matrix matrix = new Matrix();
        TreeLaminator.layoutTree(rootNode, children, matrix, 0, 0, null);
        return matrix;
    }

    private static <T> void layoutTree(T node, ChildrenFunction<T> children, Matrix<T> matrix, int row, int col, Matrix.Arrow arrow) {
        matrix.put(row, col, new Matrix.Entry<T>(arrow, node));
        ++col;
        boolean firstChild = true;
        Iterator<T> childIter = children.children(node).iterator();
        while (childIter.hasNext()) {
            T child = childIter.next();
            if (firstChild) {
                arrow = childIter.hasNext() ? Matrix.Arrow.WES : Matrix.Arrow.WE;
            } else {
                Matrix.Arrow arrow2 = arrow = childIter.hasNext() ? Matrix.Arrow.NES : Matrix.Arrow.NE;
                while (!TreeLaminator.shallowFit(row, col, child, children, matrix)) {
                    matrix.put(row, col, new Matrix.Entry(Matrix.Arrow.NS));
                    ++row;
                }
            }
            TreeLaminator.layoutTree(child, children, matrix, row, col, arrow);
            firstChild = false;
            ++row;
        }
    }

    protected static <T> int getShallowDepth(T node, ChildrenFunction<T> childNodes) {
        int depth = 1;
        Iterator<T> iter = childNodes.children(node).iterator();
        while (iter.hasNext()) {
            iter = childNodes.children(iter.next()).iterator();
            ++depth;
        }
        return depth;
    }

    protected static <T> boolean shallowFit(int row, int pos, T node, ChildrenFunction<T> childNodes, Matrix<T> matrix) {
        if (row == matrix.get().size()) {
            return true;
        }
        int depth = TreeLaminator.getShallowDepth(node, childNodes);
        for (int i = pos; i < matrix.get(row).size() && i < pos + depth; ++i) {
            if (matrix.get(row, i) == null) continue;
            return false;
        }
        return true;
    }

    @FunctionalInterface
    public static interface ChildrenFunction<N> {
        public Iterable<? extends N> children(N var1);
    }
}

