/*
 * Decompiled with CFR 0.152.
 */
package com.axis.system.jenkins.plugins.downstream.tree;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class Matrix<T> {
    private final List<List<Entry<T>>> matrix = new ArrayList<List<Entry<T>>>();

    public List<List<Entry<T>>> get() {
        return this.matrix;
    }

    public List<Entry<T>> get(int rowPos) {
        return this.matrix.get(rowPos);
    }

    public Entry<T> get(int rowPos, int colPos) {
        return this.matrix.get(rowPos).get(colPos);
    }

    public int getMaxRowWidth() {
        return this.matrix.stream().mapToInt(r -> r.size()).max().orElse(0);
    }

    public boolean isEmpty() {
        return this.matrix.isEmpty() || this.matrix.get(0).isEmpty();
    }

    public Set<T> getCellDataAsSet() {
        HashSet resultSet = new HashSet();
        for (List<Entry<T>> row : this.matrix) {
            for (Entry<T> col : row) {
                if (col == null || col.data == null) continue;
                resultSet.add(col.data);
            }
        }
        return resultSet;
    }

    public long getNumberOfCells() {
        return this.matrix.stream().mapToInt(r -> r.size()).sum();
    }

    public void put(int rowPos, int colPos, @Nullable Entry<T> value) {
        while (rowPos >= this.matrix.size()) {
            this.matrix.add(new ArrayList());
        }
        List<Entry<T>> row = this.matrix.get(rowPos);
        while (colPos >= row.size()) {
            row.add(null);
        }
        row.set(colPos, value);
    }

    public static enum Arrow {
        NS{

            public String toString() {
                return "\u2503";
            }
        }
        ,
        WE{

            public String toString() {
                return "\u2501";
            }
        }
        ,
        WES{

            public String toString() {
                return "\u2533";
            }
        }
        ,
        NES{

            public String toString() {
                return "\u2523";
            }
        }
        ,
        NE{

            public String toString() {
                return "\u2517";
            }
        };

    }

    public static class Entry<T> {
        final Arrow arrow;
        final T data;

        public Entry(@Nullable Arrow arrow, @Nullable T data) {
            this.arrow = arrow;
            this.data = data;
        }

        public Entry(@Nullable Arrow arrow) {
            this.arrow = arrow;
            this.data = null;
        }

        public String toString() {
            return "Entry{arrow=" + (Object)((Object)this.arrow) + ", data=" + this.data + '}';
        }
    }
}

