/*
 * Decompiled with CFR 0.152.
 */
package com.avigoyal.imagepick.ui;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.avigoyal.imagepick.R;

public class ActionBar
extends LinearLayout
implements View.OnClickListener {
    public static final int ID_DONE_BUTTON = 1;
    public static final int ID_BACK_BUTTON = 2;
    public static final int ID_CAMERA_BUTTON = 3;
    private TextView mTitle;
    private ImageButton mDoneButton;
    private ImageButton mCameraButton;
    private ImageView mImvBack;
    ImagePickerActionBarClickListener mImagePickerActionBarClickListener;

    public void setDoneButtonVisibility(int rightButtonVisibility) {
        this.mDoneButton.setVisibility(rightButtonVisibility);
    }

    public void setDoneButtonImageRes(int res) {
        this.mDoneButton.setImageResource(res);
    }

    public void setCameraButtonVisibility(int rightButtonVisibility) {
        this.mCameraButton.setVisibility(rightButtonVisibility);
    }

    public void setCameraButtonImageRes(int res) {
        this.mCameraButton.setImageResource(res);
    }

    public void setBackButtonVisibility(int backButtonVisibility) {
        this.mImvBack.setVisibility(backButtonVisibility);
    }

    public void setBackButtonImageRes(int res) {
        this.mImvBack.setImageResource(res);
    }

    public void setTitleVisibility(int titleVisibility) {
        this.mTitle.setVisibility(titleVisibility);
    }

    public void setTitleText(String text) {
        this.mTitle.setText((CharSequence)text);
    }

    public ActionBar(Context context) {
        super(context);
        this.initView();
    }

    public ActionBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public ActionBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.initView();
    }

    private void initView() {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.view_image_picker_action_bar, (ViewGroup)this, true);
        this.mTitle = (TextView)view.findViewById(R.id.txv_image_picker_action_bar_title);
        this.mDoneButton = (ImageButton)view.findViewById(R.id.btn_image_picker_action_bar_done);
        this.mCameraButton = (ImageButton)view.findViewById(R.id.btn_image_picker_action_bar_camera);
        this.mImvBack = (ImageView)view.findViewById(R.id.imv_image_picker_action_bar_back);
        this.mDoneButton.setOnClickListener((View.OnClickListener)this);
        this.mImvBack.setOnClickListener((View.OnClickListener)this);
        this.mCameraButton.setOnClickListener((View.OnClickListener)this);
    }

    public void setImagePickerActionBarClickListener(ImagePickerActionBarClickListener imagePickerActionBarClickListener) {
        this.mImagePickerActionBarClickListener = imagePickerActionBarClickListener;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.btn_image_picker_action_bar_camera) {
            if (this.mImagePickerActionBarClickListener != null) {
                this.mImagePickerActionBarClickListener.onImagePickerActionButtonClick(3);
            }
        } else if (v.getId() == R.id.btn_image_picker_action_bar_done) {
            if (this.mImagePickerActionBarClickListener != null) {
                this.mImagePickerActionBarClickListener.onImagePickerActionButtonClick(1);
            }
        } else if (v.getId() == R.id.imv_image_picker_action_bar_back && this.mImagePickerActionBarClickListener != null) {
            this.mImagePickerActionBarClickListener.onImagePickerActionButtonClick(2);
        }
    }

    public static interface ImagePickerActionBarClickListener {
        public void onImagePickerActionButtonClick(int var1);
    }
}

