/*
 * Decompiled with CFR 0.152.
 */
package com.avigoyal.imagepick;

import android.app.Activity;
import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.avigoyal.imagepick.ImagePickerActivity;
import com.avigoyal.imagepick.OnRecyclerItemClickListener;
import com.avigoyal.imagepick.R;
import com.avigoyal.imagepick.model.GalleryImage;
import com.bumptech.glide.Glide;
import java.io.File;
import java.util.ArrayList;

class GalleryGridAdapter
extends RecyclerView.Adapter<GalleryHolder> {
    private ArrayList<GalleryImage> mData;
    private ImagePickerActivity mActivity;
    private OnRecyclerItemClickListener mListener;

    GalleryGridAdapter(ImagePickerActivity activity, ArrayList<GalleryImage> data, OnRecyclerItemClickListener listener) {
        this.mActivity = activity;
        this.mData = data;
        this.mListener = listener;
    }

    GalleryGridAdapter(ImagePickerActivity activity, ArrayList<GalleryImage> data) {
        this.mActivity = activity;
        this.mData = data;
    }

    public GalleryHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View parentView = LayoutInflater.from((Context)this.mActivity).inflate(R.layout.grid_item_thumbnail, parent, false);
        return new GalleryHolder(parentView, this.mListener);
    }

    public void onBindViewHolder(GalleryHolder holder, int position) {
        File file;
        GalleryImage image = this.getItem(position);
        boolean isSelected = this.mActivity.containsImage(image);
        ((FrameLayout)holder.itemView).setForeground(isSelected ? ContextCompat.getDrawable((Context)this.mActivity, (int)R.drawable.gallery_photo_selected) : null);
        holder.mThumbnail.setImageResource(R.drawable.img_placeholder);
        if (null != image && null != image.mUri && !TextUtils.isEmpty((CharSequence)image.mUri.getPath()) && (file = new File(image.mUri.getPath())).exists()) {
            Glide.with((Activity)this.mActivity).load(file).override(80, 80).centerCrop().into(holder.mThumbnail);
        } else {
            holder.mThumbnail.setImageResource(R.drawable.img_placeholder);
        }
    }

    public int getItemCount() {
        return this.mData.size();
    }

    private GalleryImage getItem(int position) {
        return this.mData.get(position);
    }

    static class GalleryHolder
    extends RecyclerView.ViewHolder {
        final ImageView mThumbnail;
        final OnRecyclerItemClickListener mListener;

        GalleryHolder(final View itemView, OnRecyclerItemClickListener listener) {
            super(itemView);
            this.mListener = listener;
            this.mThumbnail = (ImageView)itemView.findViewById(R.id.thumbnail_image);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (GalleryHolder.this.mListener != null) {
                        GalleryHolder.this.mListener.onItemClick(itemView, GalleryHolder.this.getAdapterPosition());
                    }
                }
            });
        }
    }
}

