/*
 * Decompiled with CFR 0.152.
 */
package com.avigoyal.imagepick.ui;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.animation.LinearInterpolator;
import android.widget.ProgressBar;
import com.avigoyal.imagepick.R;

public class CircularProgressBar
extends ProgressBar {
    private static final String TAG = "CircularProgressBar";
    private static final int STROKE_WIDTH = 12;
    public static final int TITLE_TEXT_SIZE = 60;
    public static final int SUB_TITLE_TEXT_SIZE = 48;
    private String mTitle = "";
    private String mSubTitle = "";
    private int mStrokeWidth = 12;
    private float mTitleTextSize = 60.0f;
    private float mSubTitleTextSize = 48.0f;
    private final RectF mCircleBounds = new RectF();
    private final Paint mProgressColorPaint = new Paint();
    private final Paint mBackgroundColorPaint = new Paint();
    private final Paint mTitlePaint = new Paint();
    private final Paint mSubtitlePaint = new Paint();
    private boolean mHasShadow = true;
    private int mShadowColor = -16777216;

    public CircularProgressBar(Context context) {
        super(context);
        this.init(null, 0);
    }

    public CircularProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public CircularProgressBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    public void init(AttributeSet attrs, int style) {
        this.setLayerType(2, null);
        if (null != attrs) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.CircularProgressBar, style, 0);
            this.mHasShadow = a.getBoolean(R.styleable.CircularProgressBar_hasShadow, true);
            int color = a.getColor(R.styleable.CircularProgressBar_progressColor, 0);
            this.mProgressColorPaint.setColor(color);
            color = a.getColor(R.styleable.CircularProgressBar_backgroundColor, 0);
            this.mBackgroundColorPaint.setColor(color);
            color = a.getColor(R.styleable.CircularProgressBar_titleColor, Color.parseColor((String)"#fff2f2f2"));
            this.mTitlePaint.setColor(color);
            color = a.getColor(R.styleable.CircularProgressBar_subtitleColor, Color.parseColor((String)"#ff387CBE"));
            this.mSubtitlePaint.setColor(color);
            String t = a.getString(R.styleable.CircularProgressBar_progressTitle);
            if (t != null) {
                this.mTitle = t;
            }
            if ((t = a.getString(R.styleable.CircularProgressBar_progressSubtitle)) != null) {
                this.mSubTitle = t;
            }
            this.mStrokeWidth = a.getInt(R.styleable.CircularProgressBar_strokeWidth, 12);
            this.mTitleTextSize = a.getDimension(R.styleable.CircularProgressBar_progressTitleTextSize, 60.0f);
            this.mSubTitleTextSize = a.getDimension(R.styleable.CircularProgressBar_progressSubtitleTitleTextSize, 60.0f);
            a.recycle();
        }
        this.mProgressColorPaint.setAntiAlias(true);
        this.mProgressColorPaint.setStyle(Paint.Style.STROKE);
        this.mProgressColorPaint.setStrokeWidth((float)this.mStrokeWidth);
        this.mBackgroundColorPaint.setAntiAlias(true);
        this.mBackgroundColorPaint.setStyle(Paint.Style.STROKE);
        this.mBackgroundColorPaint.setStrokeWidth((float)this.mStrokeWidth);
        this.mTitlePaint.setTextSize(this.mTitleTextSize);
        this.mTitlePaint.setStyle(Paint.Style.FILL);
        this.mTitlePaint.setAntiAlias(true);
        this.mTitlePaint.setTypeface(Typeface.create((String)"Roboto-Thin", (int)0));
        this.mTitlePaint.setShadowLayer(0.1f, 0.0f, 1.0f, -7829368);
        this.mSubtitlePaint.setTextSize(this.mSubTitleTextSize);
        this.mSubtitlePaint.setStyle(Paint.Style.FILL);
        this.mSubtitlePaint.setAntiAlias(true);
        this.mSubtitlePaint.setTypeface(Typeface.create((String)"Roboto-Thin", (int)1));
        this.mSubtitlePaint.setShadowLayer(0.1f, 0.0f, 1.0f, -7829368);
    }

    protected synchronized void onDraw(Canvas canvas) {
        float scale;
        canvas.drawArc(this.mCircleBounds, 0.0f, 360.0f, false, this.mBackgroundColorPaint);
        int prog = this.getProgress();
        float f = scale = this.getMax() > 0 ? (float)prog / (float)this.getMax() * 360.0f : 0.0f;
        if (this.mHasShadow) {
            this.mProgressColorPaint.setShadowLayer(3.0f, 0.0f, 1.0f, this.mShadowColor);
        }
        canvas.drawArc(this.mCircleBounds, 270.0f, scale, false, this.mProgressColorPaint);
        if (!TextUtils.isEmpty((CharSequence)this.mTitle)) {
            int xPos = (int)((float)(this.getMeasuredWidth() / 2) - this.mTitlePaint.measureText(this.mTitle) / 2.0f);
            int yPos = this.getMeasuredHeight() / 2;
            float titleHeight = Math.abs(this.mTitlePaint.descent() + this.mTitlePaint.ascent());
            if (TextUtils.isEmpty((CharSequence)this.mSubTitle)) {
                yPos = (int)((float)yPos + titleHeight / 2.0f);
            }
            canvas.drawText(this.mTitle, (float)xPos, (float)yPos, this.mTitlePaint);
            yPos = (int)((float)yPos + titleHeight);
            xPos = (int)((float)(this.getMeasuredWidth() / 2) - this.mSubtitlePaint.measureText(this.mSubTitle) / 2.0f);
            canvas.drawText(this.mSubTitle, (float)xPos, (float)yPos, this.mSubtitlePaint);
        }
        super.onDraw(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = CircularProgressBar.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        int width = CircularProgressBar.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int min = Math.min(width, height);
        this.setMeasuredDimension(min + 24, min + 24);
        this.mCircleBounds.set(12.0f, 12.0f, (float)(min + 12), (float)(min + 12));
    }

    public synchronized void setProgress(int progress) {
        super.setProgress(progress);
        this.invalidate();
    }

    public void animateProgressTo(int start, final int end, final ProgressAnimationListener listener) {
        if (start != 0) {
            this.setProgress(start);
        }
        ObjectAnimator progressBarAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"animateProgress", (float[])new float[]{start, end});
        progressBarAnimator.setDuration(1500L);
        progressBarAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        progressBarAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                CircularProgressBar.this.setProgress(end);
                if (listener != null) {
                    listener.onAnimationFinish();
                }
            }

            public void onAnimationRepeat(Animator animation) {
            }

            public void onAnimationStart(Animator animation) {
                if (listener != null) {
                    listener.onAnimationStart();
                }
            }
        });
        progressBarAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int progress = ((Float)animation.getAnimatedValue()).intValue();
                if (progress != CircularProgressBar.this.getProgress()) {
                    Log.d((String)CircularProgressBar.TAG, (String)(progress + ""));
                    CircularProgressBar.this.setProgress(progress);
                    if (listener != null) {
                        listener.onAnimationProgress(progress);
                    }
                }
            }
        });
        progressBarAnimator.start();
    }

    public synchronized void setTitle(String title) {
        this.mTitle = title;
        this.invalidate();
    }

    public synchronized void setTitleTextSize(int titleTextSize) {
        this.mTitleTextSize = titleTextSize;
        this.mTitlePaint.setTextSize(this.mTitleTextSize);
        this.invalidate();
    }

    public synchronized void setSubTitle(String subtitle) {
        this.mSubTitle = subtitle;
        this.invalidate();
    }

    public synchronized void setSubTitleColor(int color) {
        this.mSubtitlePaint.setColor(color);
        this.invalidate();
    }

    public synchronized void setTitleColor(int color) {
        this.mTitlePaint.setColor(color);
        this.invalidate();
    }

    public synchronized void setHasShadow(boolean flag) {
        this.mHasShadow = flag;
        this.invalidate();
    }

    public synchronized void setShadow(int color) {
        this.mShadowColor = color;
        this.invalidate();
    }

    public String getTitle() {
        return this.mTitle;
    }

    public boolean getHasShadow() {
        return this.mHasShadow;
    }

    public static interface ProgressAnimationListener {
        public void onAnimationStart();

        public void onAnimationFinish();

        public void onAnimationProgress(int var1);
    }
}

