/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports;

import com.aventstack.extentreports.GherkinKeywordNotFoundException;
import com.aventstack.extentreports.gherkin.GherkinDialect;
import com.aventstack.extentreports.gherkin.GherkinDialectManager;
import com.aventstack.extentreports.gherkin.model.Asterisk;
import com.aventstack.extentreports.gherkin.model.IGherkinFormatterModel;
import freemarker.template.utility.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;

public class GherkinKeyword {
    private static final Logger logger = Logger.getLogger(GherkinKeyword.class.getName());
    private Class<IGherkinFormatterModel> clazz = IGherkinFormatterModel.class;
    private IGherkinFormatterModel keyword;

    public GherkinKeyword(String gk) throws ClassNotFoundException {
        GherkinDialect dialect = null;
        String apiKeyword = StringUtil.capitalize((String)gk.trim());
        String refPath = this.clazz.getPackage().getName();
        try {
            apiKeyword = apiKeyword.equals("*") ? Asterisk.class.getSimpleName() : apiKeyword;
            dialect = GherkinDialectManager.getDialect();
            if (dialect != null && !dialect.getLanguage().equalsIgnoreCase(GherkinDialectManager.getDefaultLanguage())) {
                apiKeyword = null;
                Map<String, List<String>> keywords = dialect.getKeywords();
                for (Map.Entry<String, List<String>> key : keywords.entrySet()) {
                    apiKeyword = key.getValue().stream().filter(x -> x.trim().equalsIgnoreCase(gk.trim())).findAny().map(x -> StringUtil.capitalize((String)x)).orElse(null);
                    if (apiKeyword == null) continue;
                    apiKeyword = StringUtil.capitalize((String)key.getKey());
                    break;
                }
            }
            if (apiKeyword == null) {
                throw new GherkinKeywordNotFoundException("Keyword cannot be found. You supplied: " + gk + " for dialect " + dialect + " which couldn't be mapped.");
            }
            if (apiKeyword.toLowerCase().contains("scenario") && apiKeyword.toLowerCase().contains("outline")) {
                apiKeyword = "ScenarioOutline";
            }
            String clazzName = refPath + "." + apiKeyword.replace(" ", "");
            Class<?> c = Class.forName(clazzName);
            this.keyword = (IGherkinFormatterModel)c.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    @Generated
    public Class<IGherkinFormatterModel> getClazz() {
        return this.clazz;
    }

    @Generated
    public IGherkinFormatterModel getKeyword() {
        return this.keyword;
    }
}

