/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.chaintest.plugins;

import com.aventstack.chaintest.domain.Embed;
import com.aventstack.chaintest.domain.Test;
import com.aventstack.chaintest.service.ChainPluginService;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.testng.IClassListener;
import org.testng.IExecutionListener;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class ChainTestListener
implements IExecutionListener,
ISuiteListener,
IClassListener,
ITestListener,
IInvokedMethodListener {
    private static final String TESTNG = "testng";
    private static final Map<String, Test> _suites = new ConcurrentHashMap<String, Test>();
    private static final Map<String, Test> _classes = new ConcurrentHashMap<String, Test>();
    private static final Map<String, Test> _methods = new ConcurrentHashMap<String, Test>();
    private static final ChainPluginService _service = new ChainPluginService("testng");
    private static final ThreadLocal<Test> _currentTest = new ThreadLocal();
    private static final ThreadLocal<Queue<String>> _logs = ThreadLocal.withInitial(ConcurrentLinkedQueue::new);
    private static final ThreadLocal<Boolean> _allowLog = ThreadLocal.withInitial(() -> false);

    public static void log(String log) {
        if (null != _allowLog.get() && _allowLog.get().booleanValue()) {
            _logs.get().add(log);
        }
    }

    public static void embed(byte[] data, String mimeType) {
        if (null != _allowLog.get() && _allowLog.get().booleanValue() && _currentTest.get() != null) {
            ChainPluginService.getInstance().embed(_currentTest.get(), new Embed(data, mimeType));
        }
    }

    public static void embed(File file, String mimeType) {
        if (null != _allowLog.get() && _allowLog.get().booleanValue() && _currentTest.get() != null) {
            ChainPluginService.getInstance().embed(_currentTest.get(), new Embed(file, mimeType));
        }
    }

    public static void embed(String base64, String mimeType) {
        if (null != _allowLog.get() && _allowLog.get().booleanValue() && _currentTest.get() != null) {
            ChainPluginService.getInstance().embed(_currentTest.get(), new Embed(base64, mimeType));
        }
    }

    public void onExecutionStart() {
        _service.start();
    }

    public void onExecutionFinish() {
        _service.executionFinished();
    }

    public void onStart(ISuite suite) {
        _suites.put(suite.getName(), new Test(suite.getName()));
    }

    public void onFinish(ISuite suite) {
        Test suiteTest = _suites.get(suite.getName());
        suiteTest.complete();
        _service.afterTest(suiteTest, Optional.empty());
        _service.flush();
    }

    public void onBeforeClass(ITestClass testClass) {
        Test testClazz = new Test(testClass.getName());
        _classes.put(testClass.getName(), testClazz);
        _suites.get(testClass.getXmlTest().getSuite().getName()).addChild(testClazz);
    }

    public void onAfterClass(ITestClass testClass) {
        _classes.get(testClass.getName()).complete();
    }

    public void beforeInvocation(IInvokedMethod method, ITestResult result) {
        if (method.isConfigurationMethod() && method.getTestMethod().isBeforeMethodConfiguration()) {
            _allowLog.set(true);
        }
        if (method.isTestMethod()) {
            String params;
            Test testMethod = new Test(result.getMethod().getMethodName(), Optional.of(result.getTestClass().getName()), List.of(result.getMethod().getGroups()));
            testMethod.setExternalId(result.getMethod().getQualifiedName() + "_" + result.id());
            while (!_logs.get().isEmpty()) {
                testMethod.addLog(_logs.get().poll());
            }
            _classes.get(result.getTestClass().getName()).addChild(testMethod);
            _methods.put(result.getMethod().getQualifiedName(), testMethod);
            _currentTest.set(testMethod);
            if (null != result.getParameters() && result.getParameters().length > 0 && !(params = String.join((CharSequence)", ", (CharSequence[])Arrays.stream(result.getParameters()).filter(p -> null != p && !(p instanceof Method) && !(p instanceof ITestContext) && !(p instanceof ITestResult)).map(Object::toString).toArray(String[]::new))).isEmpty()) {
                testMethod.setDescription("[" + params + "]");
            }
        }
    }

    public void afterInvocation(IInvokedMethod method, ITestResult result, ITestContext ctx) {
        if (method.isConfigurationMethod() && method.getTestMethod().isAfterMethodConfiguration()) {
            Test testMethod = _currentTest.get();
            if (null != testMethod) {
                while (!_logs.get().isEmpty()) {
                    testMethod.addLog(_logs.get().poll());
                }
            }
            _allowLog.set(false);
        }
    }

    public void onStart(ITestContext context) {
    }

    public void onFinish(ITestContext context) {
    }

    public void onTestStart(ITestResult result) {
    }

    public void onTestSuccess(ITestResult result) {
        this.onTestComplete(result);
    }

    private void onTestComplete(ITestResult result) {
        if (_methods.containsKey(result.getMethod().getQualifiedName())) {
            Test completingMethod = _currentTest.get();
            completingMethod.complete(result.getThrowable());
            while (!_logs.get().isEmpty()) {
                completingMethod.addLog(_logs.get().poll());
            }
        }
    }

    public void onTestFailure(ITestResult result) {
        this.onTestComplete(result);
    }

    public void onTestSkipped(ITestResult result) {
        this.onTestComplete(result);
    }

    public void onTestFailedWithTimeout(ITestResult result) {
        this.onTestFailure(result);
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
    }
}

