/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.chaintest.conf;

import com.aventstack.chaintest.conf.Configuration;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManager {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationManager.class);
    private static final ConfigurationManager INSTANCE = new ConfigurationManager();
    private static Configuration _conf;

    public void load() {
        if (_conf == null) {
            try {
                Configuration conf = new Configuration();
                conf.load();
                _conf = conf;
            }
            catch (IOException e) {
                log.error("Runtime exception was raised while loading configuration", (Throwable)e);
            }
        }
    }

    public static synchronized Optional<Configuration> getConfiguration() {
        if (_conf == null) {
            INSTANCE.load();
        }
        return Optional.of(_conf);
    }

    public static Map<String, String> getConfig() {
        return ConfigurationManager.getConfiguration().map(Configuration::getConfig).orElse(null);
    }

    public static boolean containsKey(String key) {
        return ConfigurationManager.getConfiguration().map(config -> config.getConfig().containsKey(key)).orElse(false);
    }

    public static String getValue(String key) {
        return ConfigurationManager.getConfiguration().map(config -> config.getConfig().get(key)).orElse(null);
    }

    public static int parseConfig(String value, int defaultValue) {
        return value != null && value.matches("\\d+") ? Integer.parseInt(value) : defaultValue;
    }

    public static long parseConfig(String value, long defaultValue) {
        return value != null && value.matches("\\d+") ? Long.parseLong(value) : defaultValue;
    }
}

