/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.chaintest.service;

import com.aventstack.chaintest.conf.ConfigurationManager;
import com.aventstack.chaintest.domain.Build;
import com.aventstack.chaintest.domain.Embed;
import com.aventstack.chaintest.domain.SystemInfo;
import com.aventstack.chaintest.domain.Test;
import com.aventstack.chaintest.generator.Generator;
import com.aventstack.chaintest.storage.StorageService;
import com.aventstack.chaintest.storage.StorageServiceFactory;
import com.aventstack.chaintest.util.DateTimeUtil;
import com.aventstack.chaintest.util.RegexUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainPluginService {
    private static final Logger logger = LoggerFactory.getLogger(ChainPluginService.class);
    private static final String GEN_PATTERN = "chaintest.generator.[a-zA-Z]+.enabled";
    private static final String STORAGE_SERVICE = "chaintest.storage.service";
    private static final String STORAGE_SERVICE_ENABLED = "chaintest.storage.service.enabled";
    private static final String DATE_TIME_PATTERN = "yyyyMMddHHmmss";
    private static final Queue<Test> _tests = new ConcurrentLinkedQueue<Test>();
    private static final Map<String, Embed> _embeds = new ConcurrentHashMap<String, Embed>();
    private static final Map<String, Queue<String>> _logs = new ConcurrentHashMap<String, Queue<String>>();
    private static final AtomicBoolean START_INVOKED = new AtomicBoolean();
    private static final List<String> SYS_PROPS = List.of("java.version", "java.vm.name", "java.vm.vendor", "java.class.version", "java.runtime.name", "os.name", "os.arch", "os.version");
    public static ChainPluginService instance;
    private final Build _build;
    private final String _testRunner;
    private final List<Generator> _generators = new ArrayList<Generator>(3);
    private StorageService _storageService;

    public ChainPluginService(String testRunner) {
        instance = this;
        this._build = new Build(testRunner);
        this._build.setSystemInfo(this.getProps());
        this._testRunner = testRunner;
    }

    private List<SystemInfo> getProps() {
        ArrayList<SystemInfo> list = new ArrayList<SystemInfo>();
        for (String prop : SYS_PROPS) {
            list.add(new SystemInfo(prop, System.getProperty(prop)));
        }
        return list;
    }

    public Build getBuild() {
        return this._build;
    }

    public Map<String, Queue<String>> getLogs() {
        return _logs;
    }

    public void register(Generator generator) {
        this._generators.add(generator);
    }

    public void register(Collection<Generator> generators) {
        this._generators.addAll(generators);
    }

    public void start() {
        Optional<Map<String, String>> config = Optional.ofNullable(ConfigurationManager.getConfig());
        if (!START_INVOKED.getAndSet(true)) {
            config.ifPresent(this::init);
        }
        this._generators.stream().filter(x -> !x.started()).forEach(x -> x.start(config, this._testRunner, this._build));
    }

    private void init(Map<String, String> config) {
        this._build.setProjectName(config.get("chaintest.project.name"));
        this.register(config);
        this.startStorageService(config);
    }

    private void register(Map<String, String> config) {
        HashSet generatorNames = new HashSet();
        this._generators.forEach(x -> generatorNames.add(x.getName()));
        for (Map.Entry<String, String> entry : config.entrySet()) {
            logger.trace("Reading property: {}", (Object)entry.getKey());
            if (!entry.getKey().matches(GEN_PATTERN) || generatorNames.contains(entry.getKey().split("\\.")[2])) continue;
            String enabled = entry.getValue();
            if (!Boolean.parseBoolean(enabled)) {
                logger.debug("Generator {} was not enabled. To enable, set property {}=true in your configuration", (Object)entry.getKey(), (Object)entry.getKey());
                continue;
            }
            String classNameKey = RegexUtil.match("(.*)\\.", entry.getKey()) + "class-name";
            logger.debug("Found configuration entry {}, will use {} to resolve class", (Object)entry.getKey(), (Object)classNameKey);
            if (!config.containsKey(classNameKey)) {
                logger.info("{} was true from configuration but the required property {} was not provided", (Object)entry.getKey(), (Object)classNameKey);
                continue;
            }
            String className = config.get(classNameKey);
            try {
                Class<?> clazz = Class.forName(className);
                Generator gen = (Generator)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this._generators.add(gen);
            }
            catch (Exception e) {
                logger.error("Failed to create an instance of {} generator", (Object)className, (Object)e);
            }
        }
    }

    private void startStorageService(Map<String, String> config) {
        String name;
        StorageService storageService;
        if (config.containsKey(STORAGE_SERVICE_ENABLED) && Boolean.parseBoolean(config.get(STORAGE_SERVICE_ENABLED)) && (storageService = StorageServiceFactory.getStorageService(name = config.get(STORAGE_SERVICE))).create(config)) {
            this._storageService = storageService;
            String prefix = DateTimeUtil.toFormat(this._build.getStartedAt(), DATE_TIME_PATTERN);
            this._storageService.withPrefix(prefix);
        }
    }

    public void afterTest(Test test, Optional<Throwable> throwable) {
        _tests.add(test);
        this._build.updateStats(test);
        this._generators.forEach(x -> x.afterTest(test, throwable));
    }

    public void flush() {
        this.embedRemaining();
        this.attachLogs();
        this._build.complete();
        this._generators.forEach(x -> x.flush(_tests));
    }

    public void executionFinished() {
        if (null != this._storageService) {
            this._storageService.close();
        }
        this.flush();
        this._generators.forEach(Generator::executionFinished);
    }

    public void embed(String externalId, byte[] data, String mimeType) {
        this.embed(externalId, new Embed(data, mimeType));
    }

    public void embed(String externalId, File file, String mimeType) {
        this.embed(externalId, new Embed(file, mimeType));
    }

    public void embed(String externalId, String base64, String mimeType) {
        this.embed(externalId, new Embed(base64, mimeType));
    }

    public void embed(String externalId, Embed embed) {
        _embeds.put(externalId, embed);
        this.embed(_tests, externalId, embed);
    }

    public void embed(Method method, byte[] data, String mimeType) {
        this.embed(this.getQualifiedName(method), new Embed(data, mimeType));
    }

    public void embed(Method method, File file, String mimeType) {
        this.embed(this.getQualifiedName(method), new Embed(file, mimeType));
    }

    public void embed(Method method, String base64, String mimeType) {
        this.embed(this.getQualifiedName(method), new Embed(base64, mimeType));
    }

    public void embed(Method method, Embed embed) {
        String externalId = this.getQualifiedName(method);
        _embeds.put(externalId, embed);
        this.embed(_tests, externalId, embed);
    }

    public void embed(Test test, byte[] data, String mimeType) {
        this.embed(test, new Embed(data, mimeType));
    }

    public void embed(Test test, File file, String mimeType) {
        this.embed(test, new Embed(file, mimeType));
    }

    public void embed(Test test, String base64, String mimeType) {
        this.embed(test, new Embed(base64, mimeType));
    }

    public void embed(Test test, Embed embed) {
        this.putBlob(test, embed);
        test.addEmbed(embed);
        if (null != test.getExternalId()) {
            _embeds.remove(test.getExternalId());
        }
    }

    public String getQualifiedName(Method method) {
        return method.getDeclaringClass().getName() + "." + method.getName();
    }

    private void putBlob(Test test, Embed embed) {
        if (null != this._storageService) {
            this._storageService.upload(test, embed);
        }
    }

    private void embed(Queue<Test> tests, String externalId, Embed embed) {
        Optional<Test> any = this.testByExternalId(tests, externalId);
        if (any.isPresent()) {
            this.putBlob(any.get(), embed);
            this.embed(any.get(), embed);
            _embeds.remove(externalId);
        }
    }

    private Optional<Test> testByExternalId(Queue<Test> tests, String externalId) {
        for (Test test : tests) {
            if (externalId.equals(test.getExternalId())) {
                return Optional.of(test);
            }
            Optional<Test> child = this.testByExternalId(test.getChildren(), externalId);
            if (!child.isPresent()) continue;
            return child;
        }
        return Optional.empty();
    }

    private void embedRemaining() {
        for (Map.Entry<String, Embed> entry : _embeds.entrySet()) {
            this.embed(_tests, entry.getKey(), entry.getValue());
        }
    }

    public void addSystemInfo(String key, String value) {
        this._build.getSystemInfo().add(new SystemInfo(key, value));
    }

    public void addSystemInfo(Map<String, String> sysInfo) {
        sysInfo.forEach(this::addSystemInfo);
    }

    public void log(String externalId, String message) {
        this.testByExternalId(_tests, externalId).ifPresentOrElse(test -> test.addLog(message), () -> _logs.computeIfAbsent(externalId, k -> new ConcurrentLinkedQueue()).add(message));
    }

    public void log(Method method, String message) {
        this.log(this.getQualifiedName(method), message);
    }

    private void attachLog(Test test, String externalId) {
        Queue<String> logs = _logs.get(externalId);
        if (null != logs) {
            logs.forEach(test::addLog);
            _logs.remove(externalId);
        }
    }

    private void attachLogs() {
        for (Map.Entry<String, Queue<String>> entry : _logs.entrySet()) {
            Optional<Test> any = this.testByExternalId(_tests, entry.getKey());
            any.ifPresent(test -> this.attachLog((Test)test, (String)entry.getKey()));
        }
    }

    private List<Test> flattenTests() {
        return _tests.stream().flatMap(test -> this.flattenTests((Test)test).stream()).collect(Collectors.toList());
    }

    private List<Test> flattenTests(Test test) {
        return Stream.concat(Stream.of(test), test.getChildren().stream().flatMap(child -> this.flattenTests((Test)child).stream())).collect(Collectors.toList());
    }

    @Generated
    public static ChainPluginService getInstance() {
        return instance;
    }
}

