/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.chaintest.generator;

import com.aventstack.chaintest.generator.FreemarkerConfig;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileGenerator {
    private static final Logger log = LoggerFactory.getLogger(FileGenerator.class);
    protected static final String BASE_PROPERTY = "chaintest.generator";
    protected static final String PROP_OUT_FILE_KEY = "output-file";
    protected static final String DEFAULT_OUT_DIR = "target/chaintest/";
    private final String _propOutFile;
    private final String _defaultOutFileName;
    private Template _template;
    private Class<?> _classForTemplateLoading;
    private String _basePackagePath;
    private String _templateName;

    protected FileGenerator(String gen) {
        this._propOutFile = "chaintest.generator." + gen + ".output-file";
        this._defaultOutFileName = gen + ".html";
    }

    protected String processTemplate(Map<String, Object> objectModel, File outputFile) {
        String string;
        File dir;
        File file = dir = Files.isDirectory(outputFile.toPath(), new LinkOption[0]) ? outputFile : outputFile.getParentFile();
        if (null != dir) {
            dir.mkdirs();
        }
        if (null == this._template) {
            try {
                this.cacheTemplate(this._classForTemplateLoading, this._basePackagePath, this._templateName);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        FileWriter out = new FileWriter(outputFile);
        try {
            this._template.process(objectModel, (Writer)out);
            string = out.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (TemplateException e) {
                log.error("Error processing template", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        out.close();
        return string;
    }

    protected String processTemplate(Map<String, Object> objectModel, String outputFile) {
        return this.processTemplate(objectModel, new File(outputFile));
    }

    protected void cacheTemplate(Class<?> classForTemplateLoading, String basePackagePath, String templateName) throws IOException {
        this._classForTemplateLoading = classForTemplateLoading;
        this._basePackagePath = basePackagePath;
        this._templateName = templateName;
        if (this._template == null) {
            log.debug("Loading template {} for class {} with basePackagePath {}", new Object[]{templateName, classForTemplateLoading, basePackagePath});
            Configuration cfg = new FreemarkerConfig().getConfig(classForTemplateLoading, basePackagePath);
            this._template = cfg.getTemplate(templateName);
        }
    }

    protected File getOutFile() {
        String envOutFile = System.getenv(this._propOutFile);
        if (null != envOutFile && !envOutFile.isEmpty()) {
            return new File(envOutFile);
        }
        String sysOutFile = System.getProperty(this._propOutFile);
        if (null != sysOutFile && !sysOutFile.isEmpty()) {
            return new File(sysOutFile);
        }
        return null;
    }

    protected File getOutFile(Map<String, String> config) {
        File outFile = this.getOutFile();
        if (null != outFile) {
            return outFile;
        }
        Object outputFileName = Optional.ofNullable(config.get(this._propOutFile)).filter(name -> !name.isEmpty()).orElse(DEFAULT_OUT_DIR + this._defaultOutFileName);
        if (!((String)outputFileName).endsWith("htm") && !((String)outputFileName).endsWith("html")) {
            outputFileName = (String)outputFileName + "/" + this._defaultOutFileName;
        }
        return new File((String)outputFileName);
    }
}

