/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.chaintest.storage;

import com.aventstack.chaintest.domain.Embed;
import com.aventstack.chaintest.domain.Test;
import com.aventstack.chaintest.storage.StorageService;
import java.io.File;
import java.util.Base64;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;

public class AWSS3Client
implements StorageService {
    private static final Logger log = LoggerFactory.getLogger(AWSS3Client.class);
    private static final String AWS_ACCESS_KEY_ID = "AWS_ACCESS_KEY_ID";
    private static final String AWS_SECRET_ACCESS_KEY = "AWS_SECRET_ACCESS_KEY";
    private static final String AWS_DEFAULT_REGION = "AWS_DEFAULT_REGION";
    private S3Client _client;
    private String _bucket;
    private String _prefix;

    @Override
    public boolean create(Map<String, String> config) {
        try {
            this._client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().httpClientBuilder((SdkHttpClient.Builder)ApacheHttpClient.builder())).credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.builder().build())).build();
            this._bucket = config.getOrDefault("chaintest.storage.service.container-name", "chaintest");
            this._bucket = this._bucket.isBlank() ? "chaintest" : this._bucket;
            log.info("S3 client ready, using bucket: {}", (Object)this._bucket);
            return true;
        }
        catch (Exception e) {
            log.error("Failed to create AWS S3 client", (Throwable)e);
            return false;
        }
    }

    @Override
    public void withPrefix(String prefix) {
        this._prefix = prefix;
    }

    private void createBucket(String bucketName) {
        try {
            this._client.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(bucketName).build());
            log.debug("Creating bucket: {}", (Object)bucketName);
            this._client.waiter().waitUntilBucketExists((HeadBucketRequest)HeadBucketRequest.builder().bucket(bucketName).build());
            log.debug("{} is ready.", (Object)bucketName);
        }
        catch (S3Exception e) {
            log.error("Failed to create bucket", (Throwable)e);
        }
    }

    @Override
    public void upload(Test test, String key, byte[] data) {
        String prefixKey = this.getPrefixKey(this._prefix, key);
        this._client.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(this._bucket).key(prefixKey).build(), RequestBody.fromBytes((byte[])data));
        this.assignURL(test, prefixKey);
    }

    private void assignURL(Test test, String key) {
        test.addScreenshotURL(this._client.utilities().getUrl(builder -> builder.bucket(this._bucket).key(key)).toExternalForm());
    }

    @Override
    public void upload(Test test, String key, String base64) {
        byte[] data = Base64.getDecoder().decode(base64.getBytes());
        this.upload(test, key, data);
    }

    @Override
    public void upload(Test test, String key, File file) {
        String prefixKey = this.getPrefixKey(this._prefix, key);
        this._client.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(this._bucket).key(prefixKey).build(), RequestBody.fromFile((File)file));
        this.assignURL(test, prefixKey);
    }

    @Override
    public void upload(Test test, Embed embed) {
        if (null != embed.getBytes()) {
            this.upload(test, embed.getName(), embed.getBytes());
        } else if (null != embed.getBase64() && !embed.getBase64().isBlank()) {
            this.upload(test, embed.getName(), embed.getBase64());
        } else if (null != embed.getFile()) {
            this.upload(test, embed.getName(), embed.getFile());
        } else {
            log.error("Unable to upload Embed to Azure Blob Storage. Source missing");
        }
    }

    @Override
    public void close() {
        this._client.close();
    }
}

