/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.chaintest.generator;

import com.aventstack.chaintest.domain.Build;
import com.aventstack.chaintest.domain.Test;
import com.aventstack.chaintest.generator.FileGenerator;
import com.aventstack.chaintest.generator.Generator;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainTestEmailGenerator
extends FileGenerator
implements Generator {
    private static final Logger log = LoggerFactory.getLogger(ChainTestEmailGenerator.class);
    private static final String NAME = "email";
    private static final String BASE_PROPERTY = "chaintest.generator.email";
    private static final String PROP_ENABLED = "chaintest.generator.email.enabled";
    private static final String PROP_OUT_FILE_NAME = "chaintest.generator.email.output-file";
    private static final String DEFAULT_OUT_DIR = "target/chaintest/";
    private static final String DEFAULT_OUT_FILE_NAME = "Email.html";
    private static final String TEMPLATE_DIR = "email/";
    private static final String INDEX = "index.ftl";
    private boolean _started;
    private Build _build;
    private String _source;
    private File _outFile;

    public String getSource() {
        return this._source;
    }

    @Override
    public void start(Optional<Map<String, String>> config, String testRunner, Build build) {
        if (config.isEmpty()) {
            log.debug("Unable to load {} configuration, generator will now shutdown and no output will be produced", (Object)ChainTestEmailGenerator.class.getSimpleName());
            return;
        }
        String enabled = config.get().get(PROP_ENABLED);
        if (!Boolean.parseBoolean(enabled)) {
            log.debug("{} Generator was not enabled. To enable, set property {}=true in your configuration", (Object)NAME, (Object)PROP_ENABLED);
            return;
        }
        Object outputFileName = Optional.ofNullable(config.get().get(PROP_OUT_FILE_NAME)).filter(name -> !name.isEmpty()).orElse("target/chaintest/Email.html");
        if (!((String)outputFileName).endsWith("htm") && !((String)outputFileName).endsWith("html")) {
            outputFileName = (String)outputFileName + "/Email.html";
        }
        this._outFile = new File((String)outputFileName);
        log.trace("Start was called for testRunner: {}", (Object)testRunner);
        this._build = build;
        try {
            this.cacheTemplate(ChainTestEmailGenerator.class, TEMPLATE_DIR, INDEX);
            this._started = true;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean started() {
        return this._started;
    }

    @Override
    public void flush(Queue<Test> tests) {
        if (null == this._build || null == tests || tests.isEmpty() || this._build.getRunStats().isEmpty()) {
            log.debug("No tests to process, skipping flush");
            return;
        }
        this._source = this.processTemplate(Map.of("build", this._build, "tests", tests), this._outFile);
    }

    @Override
    public void afterTest(Test test, Optional<Throwable> throwable) {
    }

    @Override
    public void executionFinished() {
    }

    @Override
    public String getName() {
        return NAME;
    }
}

