/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.chaintest.generator;

import com.aventstack.chaintest.domain.Build;
import com.aventstack.chaintest.domain.ExecutionStage;
import com.aventstack.chaintest.domain.Tag;
import com.aventstack.chaintest.domain.Test;
import com.aventstack.chaintest.generator.Generator;
import com.aventstack.chaintest.http.ChainTestApiClient;
import com.aventstack.chaintest.http.HttpMethod;
import com.aventstack.chaintest.http.WrappedResponseAsync;
import java.io.IOException;
import java.net.http.HttpResponse;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainLPGenerator
implements Generator {
    private static final Logger log = LoggerFactory.getLogger(ChainLPGenerator.class);
    private static final String NAME = "chainlp";
    private static final String HTTP_CLIENT_ENABLED = "chaintest.generator.chainlp.enabled";
    private static final ConcurrentHashMap<String, WrappedResponseAsync<Test>> _wrappedResponses = new ConcurrentHashMap();
    private static final AtomicBoolean CALLBACK_INVOKED = new AtomicBoolean();
    private static ChainLPGenerator instance;
    private String _testRunner;
    private ChainTestApiClient _client;
    private Build _build;
    private Queue<Test> _tests;

    public ChainLPGenerator(String testRunner) {
        this._testRunner = testRunner;
        instance = this;
    }

    public ChainLPGenerator() {
        this("");
    }

    public void client(ChainTestApiClient client) {
        this._client = client;
    }

    public ChainTestApiClient getClient() {
        return this._client;
    }

    public ChainLPGenerator getInstance() {
        return instance;
    }

    public Build getBuild() {
        return this._build;
    }

    @Override
    public void start(Optional<Map<String, String>> config, String testRunner, Build build) {
        this._testRunner = testRunner;
        if (this.started()) {
            return;
        }
        if (config.isEmpty()) {
            log.debug("Unable to load {} configuration, generator will now shutdown and no output will be produced", (Object)ChainLPGenerator.class.getSimpleName());
            return;
        }
        String enabled = config.get().get(HTTP_CLIENT_ENABLED);
        if (!Boolean.parseBoolean(enabled)) {
            log.debug("Http Generator was not enabled. To enable Http generator, set property {}=true in your configuration", (Object)HTTP_CLIENT_ENABLED);
            return;
        }
        if (null == this._client) {
            try {
                this._client = new ChainTestApiClient();
            }
            catch (Exception e) {
                log.error("Failed to create an instance of {}", ChainTestApiClient.class, (Object)e);
                return;
            }
        }
        log.trace("Starting new build, but events will only be sent to API if build is successfully created");
        String projectName = this._client.config().getConfig().getOrDefault("chaintest.project.name", "");
        Build buildReq = new Build(projectName, this._testRunner);
        buildReq.setSystemInfo(build.getSystemInfo());
        try {
            HttpResponse<Build> response = this._client.retryHandler().trySend(buildReq, Build.class, HttpMethod.POST);
            if (null != response && 200 == response.statusCode()) {
                buildReq = response.body();
                this._build = build;
                this._build.setId(buildReq.getId());
                this._build.setProjectId(buildReq.getProjectId());
                CALLBACK_INVOKED.set(true);
                log.debug("All tests in this run will be associated with buildId: {}", (Object)this._build.getId());
            }
        }
        catch (IOException | InterruptedException e) {
            log.debug("Failed to send Build. PluginService will shutdown and future events will be ignored", (Throwable)e);
        }
    }

    @Override
    public boolean started() {
        return CALLBACK_INVOKED.get();
    }

    @Override
    public void executionFinished() {
        if (!this.started()) {
            return;
        }
        this._build.setExecutionStage(ExecutionStage.FINISHED);
        this.flush(this._tests);
    }

    @Override
    public void flush(Queue<Test> tests) {
        if (!this.started()) {
            return;
        }
        this._tests = tests;
        Map<String, WrappedResponseAsync<Test>> failures = this._client.retryHandler().sendWithRetries(_wrappedResponses);
        try {
            if (!failures.isEmpty()) {
                throw new IllegalStateException("Failed to transfer " + failures.size() + " tests");
            }
            this._client.retryHandler().trySend(this._build, Build.class, HttpMethod.PUT);
        }
        catch (Exception e) {
            CALLBACK_INVOKED.set(false);
            log.error("Failed to send test(s) or build. PluginService will shutdown and future events will be ignored", (Throwable)e);
        }
    }

    @Override
    public void afterTest(Test test, Optional<Throwable> throwable) {
        if (!this.started()) {
            return;
        }
        this.updateAttributes(test);
        WrappedResponseAsync<Test> wrapper = new WrappedResponseAsync<Test>(test);
        _wrappedResponses.put(test.getClientId().toString(), wrapper);
        try {
            CompletableFuture future = this._client.sendAsync((Test)wrapper.getEntity(), Test.class);
            wrapper.setResponseFuture(future);
        }
        catch (IOException e) {
            log.error("Exception sending test", (Throwable)e);
        }
    }

    private void updateAttributes(Test test) {
        test.setBuildId(this._build.getId());
        test.setProjectId(this._build.getProjectId());
        this._build.addTags((Collection<Tag>)test.getTags());
        test.getChildren().forEach(this::updateAttributes);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

