/*
 * Decompiled with CFR 0.152.
 */
package com.avast.android.dialogs.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.view.View;
import android.widget.DatePicker;
import com.avast.android.dialogs.R;
import com.avast.android.dialogs.core.BaseDialogBuilder;
import com.avast.android.dialogs.core.BaseDialogFragment;
import com.avast.android.dialogs.iface.IDateDialogListener;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class DatePickerDialogFragment
extends BaseDialogFragment {
    protected static final String ARG_ZONE = "zone";
    protected static final String ARG_TITLE = "title";
    protected static final String ARG_POSITIVE_BUTTON = "positive_button";
    protected static final String ARG_NEGATIVE_BUTTON = "negative_button";
    protected static final String ARG_DATE = "date";
    protected static final String ARG_24H = "24h";
    DatePicker mDatePicker;
    Calendar mCalendar;

    public static SimpleDialogBuilder createBuilder(Context context, FragmentManager fragmentManager) {
        return new SimpleDialogBuilder(context, fragmentManager, (Class<? extends DatePickerDialogFragment>)DatePickerDialogFragment.class);
    }

    protected List<IDateDialogListener> getDialogListeners() {
        return this.getDialogListeners(IDateDialogListener.class);
    }

    @Override
    protected BaseDialogFragment.Builder build(BaseDialogFragment.Builder builder) {
        CharSequence negativeButtonText;
        CharSequence positiveButtonText;
        CharSequence title = this.getTitle();
        if (!TextUtils.isEmpty((CharSequence)title)) {
            builder.setTitle(title);
        }
        if (!TextUtils.isEmpty((CharSequence)(positiveButtonText = this.getPositiveButtonText()))) {
            builder.setPositiveButton(positiveButtonText, new View.OnClickListener(){

                public void onClick(View view) {
                    for (IDateDialogListener listener : DatePickerDialogFragment.this.getDialogListeners()) {
                        listener.onPositiveButtonClicked(DatePickerDialogFragment.this.mRequestCode, DatePickerDialogFragment.this.getDate());
                    }
                    DatePickerDialogFragment.this.dismiss();
                }
            });
        }
        if (!TextUtils.isEmpty((CharSequence)(negativeButtonText = this.getNegativeButtonText()))) {
            builder.setNegativeButton(negativeButtonText, new View.OnClickListener(){

                public void onClick(View view) {
                    for (IDateDialogListener listener : DatePickerDialogFragment.this.getDialogListeners()) {
                        listener.onNegativeButtonClicked(DatePickerDialogFragment.this.mRequestCode, DatePickerDialogFragment.this.getDate());
                    }
                    DatePickerDialogFragment.this.dismiss();
                }
            });
        }
        this.mDatePicker = (DatePicker)builder.getLayoutInflater().inflate(R.layout.sdl_datepicker, null);
        builder.setView((View)this.mDatePicker);
        TimeZone zone = TimeZone.getTimeZone(this.getArguments().getString(ARG_ZONE));
        this.mCalendar = Calendar.getInstance(zone);
        this.mCalendar.setTimeInMillis(this.getArguments().getLong(ARG_DATE, System.currentTimeMillis()));
        this.mDatePicker.updateDate(this.mCalendar.get(1), this.mCalendar.get(2), this.mCalendar.get(5));
        return builder;
    }

    protected CharSequence getTitle() {
        return this.getArguments().getCharSequence(ARG_TITLE);
    }

    protected CharSequence getPositiveButtonText() {
        return this.getArguments().getCharSequence(ARG_POSITIVE_BUTTON);
    }

    protected CharSequence getNegativeButtonText() {
        return this.getArguments().getCharSequence(ARG_NEGATIVE_BUTTON);
    }

    public Date getDate() {
        this.mCalendar.set(1, this.mDatePicker.getYear());
        this.mCalendar.set(2, this.mDatePicker.getMonth());
        this.mCalendar.set(5, this.mDatePicker.getDayOfMonth());
        return this.mCalendar.getTime();
    }

    public static class SimpleDialogBuilder
    extends BaseDialogBuilder<SimpleDialogBuilder> {
        Date mDate = new Date();
        String mTimeZone = null;
        private CharSequence mTitle;
        private CharSequence mPositiveButtonText;
        private CharSequence mNegativeButtonText;
        private boolean mShowDefaultButton = true;
        private boolean m24h;

        protected SimpleDialogBuilder(Context context, FragmentManager fragmentManager, Class<? extends DatePickerDialogFragment> clazz) {
            super(context, fragmentManager, clazz);
            this.m24h = DateFormat.is24HourFormat((Context)context);
        }

        public SimpleDialogBuilder setTitle(int titleResourceId) {
            this.mTitle = this.mContext.getString(titleResourceId);
            return this;
        }

        public SimpleDialogBuilder setTitle(CharSequence title) {
            this.mTitle = title;
            return this;
        }

        public SimpleDialogBuilder setPositiveButtonText(int textResourceId) {
            this.mPositiveButtonText = this.mContext.getString(textResourceId);
            return this;
        }

        public SimpleDialogBuilder setPositiveButtonText(CharSequence text) {
            this.mPositiveButtonText = text;
            return this;
        }

        public SimpleDialogBuilder setNegativeButtonText(int textResourceId) {
            this.mNegativeButtonText = this.mContext.getString(textResourceId);
            return this;
        }

        public SimpleDialogBuilder setNegativeButtonText(CharSequence text) {
            this.mNegativeButtonText = text;
            return this;
        }

        public SimpleDialogBuilder setDate(Date date) {
            this.mDate = date;
            return this;
        }

        public SimpleDialogBuilder setTimeZone(String zone) {
            this.mTimeZone = zone;
            return this;
        }

        public SimpleDialogBuilder set24hour(boolean state) {
            this.m24h = state;
            return this;
        }

        @Override
        protected Bundle prepareArguments() {
            Bundle args = new Bundle();
            args.putCharSequence(DatePickerDialogFragment.ARG_TITLE, this.mTitle);
            args.putCharSequence(DatePickerDialogFragment.ARG_POSITIVE_BUTTON, this.mPositiveButtonText);
            args.putCharSequence(DatePickerDialogFragment.ARG_NEGATIVE_BUTTON, this.mNegativeButtonText);
            args.putLong(DatePickerDialogFragment.ARG_DATE, this.mDate.getTime());
            args.putBoolean(DatePickerDialogFragment.ARG_24H, this.m24h);
            if (this.mTimeZone != null) {
                args.putString(DatePickerDialogFragment.ARG_ZONE, this.mTimeZone);
            } else {
                args.putString(DatePickerDialogFragment.ARG_ZONE, TimeZone.getDefault().getID());
            }
            return args;
        }

        @Override
        protected SimpleDialogBuilder self() {
            return this;
        }
    }
}

