/*
 * ACI Services API
 * API for methods pertaining to all ACI services
 *
 * OpenAPI spec version: 3.0.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.autocheckinsurance.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.autocheckinsurance.sdk.model.UnprocessedRiskCalculationRequests;
import com.autocheckinsurance.sdk.model.VehicleRiskResult;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * RiskCalculationResponse
 */

public class RiskCalculationResponse {
  /**
   * The risk prediction type used
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    DEFAULT("Default"),
    
    CA("CA"),
    
    FL("FL"),
    
    SC("SC"),
    
    NM("NM"),
    
    AZ("AZ");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String text) {
      for (TypeEnum b : TypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return TypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("type")
  private TypeEnum type = null;

  @SerializedName("unprocessed")
  private UnprocessedRiskCalculationRequests unprocessed = null;

  @SerializedName("vehicleRiskResults")
  private java.util.List<VehicleRiskResult> vehicleRiskResults = null;

  public RiskCalculationResponse type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * The risk prediction type used
   * @return type
  **/
  @ApiModelProperty(value = "The risk prediction type used")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public RiskCalculationResponse unprocessed(UnprocessedRiskCalculationRequests unprocessed) {
    this.unprocessed = unprocessed;
    return this;
  }

   /**
   * Get unprocessed
   * @return unprocessed
  **/
  @ApiModelProperty(value = "")
  public UnprocessedRiskCalculationRequests getUnprocessed() {
    return unprocessed;
  }

  public void setUnprocessed(UnprocessedRiskCalculationRequests unprocessed) {
    this.unprocessed = unprocessed;
  }

  public RiskCalculationResponse vehicleRiskResults(java.util.List<VehicleRiskResult> vehicleRiskResults) {
    this.vehicleRiskResults = vehicleRiskResults;
    return this;
  }

  public RiskCalculationResponse addVehicleRiskResultsItem(VehicleRiskResult vehicleRiskResultsItem) {
    if (this.vehicleRiskResults == null) {
      this.vehicleRiskResults = new java.util.ArrayList<>();
    }
    this.vehicleRiskResults.add(vehicleRiskResultsItem);
    return this;
  }

   /**
   * the list of results for each vehicle identification numbers/effective end date combination
   * @return vehicleRiskResults
  **/
  @ApiModelProperty(value = "the list of results for each vehicle identification numbers/effective end date combination")
  public java.util.List<VehicleRiskResult> getVehicleRiskResults() {
    return vehicleRiskResults;
  }

  public void setVehicleRiskResults(java.util.List<VehicleRiskResult> vehicleRiskResults) {
    this.vehicleRiskResults = vehicleRiskResults;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RiskCalculationResponse riskCalculationResponse = (RiskCalculationResponse) o;
    return Objects.equals(this.type, riskCalculationResponse.type) &&
        Objects.equals(this.unprocessed, riskCalculationResponse.unprocessed) &&
        Objects.equals(this.vehicleRiskResults, riskCalculationResponse.vehicleRiskResults);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, unprocessed, vehicleRiskResults);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RiskCalculationResponse {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    unprocessed: ").append(toIndentedString(unprocessed)).append("\n");
    sb.append("    vehicleRiskResults: ").append(toIndentedString(vehicleRiskResults)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

