/*
 * Decompiled with CFR 0.152.
 */
package com.autocheckinsurance.sdk.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;

@ApiModel(description="Please note that ownership activity is a separately licensed section of the vehicle history responses. Please contact your Red Mountain sales team if you wish to receive ownership activity information")
public class VehicleOwnershipActivity {
    @SerializedName(value="accidentEvent")
    private Boolean accidentEvent = null;
    @SerializedName(value="duration")
    private String duration = null;
    @SerializedName(value="end")
    private LocalDate end = null;
    @SerializedName(value="sequenceNumber")
    private Integer sequenceNumber = null;
    @SerializedName(value="start")
    private LocalDate start = null;
    @SerializedName(value="state")
    private String state = null;
    @SerializedName(value="yearPurchased")
    private Integer yearPurchased = null;

    public VehicleOwnershipActivity accidentEvent(Boolean accidentEvent) {
        this.accidentEvent = accidentEvent;
        return this;
    }

    @ApiModelProperty(value="indicates if this owner had any accident related activity with this vehicle")
    public Boolean isAccidentEvent() {
        return this.accidentEvent;
    }

    public void setAccidentEvent(Boolean accidentEvent) {
        this.accidentEvent = accidentEvent;
    }

    public VehicleOwnershipActivity duration(String duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(value="the duration of ownership")
    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public VehicleOwnershipActivity end(LocalDate end) {
        this.end = end;
        return this;
    }

    @ApiModelProperty(value="the date ownership ended")
    public LocalDate getEnd() {
        return this.end;
    }

    public void setEnd(LocalDate end) {
        this.end = end;
    }

    public VehicleOwnershipActivity sequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        return this;
    }

    @ApiModelProperty(value="the sequence number")
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public VehicleOwnershipActivity start(LocalDate start) {
        this.start = start;
        return this;
    }

    @ApiModelProperty(value="the date ownership started")
    public LocalDate getStart() {
        return this.start;
    }

    public void setStart(LocalDate start) {
        this.start = start;
    }

    public VehicleOwnershipActivity state(String state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="the state in which the ownership occurred")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public VehicleOwnershipActivity yearPurchased(Integer yearPurchased) {
        this.yearPurchased = yearPurchased;
        return this;
    }

    @ApiModelProperty(value="the year this owner purchased the vehicle")
    public Integer getYearPurchased() {
        return this.yearPurchased;
    }

    public void setYearPurchased(Integer yearPurchased) {
        this.yearPurchased = yearPurchased;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VehicleOwnershipActivity vehicleOwnershipActivity = (VehicleOwnershipActivity)o;
        return Objects.equals(this.accidentEvent, vehicleOwnershipActivity.accidentEvent) && Objects.equals(this.duration, vehicleOwnershipActivity.duration) && Objects.equals(this.end, vehicleOwnershipActivity.end) && Objects.equals(this.sequenceNumber, vehicleOwnershipActivity.sequenceNumber) && Objects.equals(this.start, vehicleOwnershipActivity.start) && Objects.equals(this.state, vehicleOwnershipActivity.state) && Objects.equals(this.yearPurchased, vehicleOwnershipActivity.yearPurchased);
    }

    public int hashCode() {
        return Objects.hash(this.accidentEvent, this.duration, this.end, this.sequenceNumber, this.start, this.state, this.yearPurchased);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VehicleOwnershipActivity {\n");
        sb.append("    accidentEvent: ").append(this.toIndentedString(this.accidentEvent)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("    sequenceNumber: ").append(this.toIndentedString(this.sequenceNumber)).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    yearPurchased: ").append(this.toIndentedString(this.yearPurchased)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

