/*
 * Decompiled with CFR 0.152.
 */
package com.autocheckinsurance.sdk.api;

import com.autocheckinsurance.sdk.ApiCallback;
import com.autocheckinsurance.sdk.ApiClient;
import com.autocheckinsurance.sdk.ApiException;
import com.autocheckinsurance.sdk.ApiResponse;
import com.autocheckinsurance.sdk.Configuration;
import com.autocheckinsurance.sdk.Pair;
import com.autocheckinsurance.sdk.ProgressRequestBody;
import com.autocheckinsurance.sdk.ProgressResponseBody;
import com.autocheckinsurance.sdk.model.Empty;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class AutoCheckInsuranceApi {
    private ApiClient apiClient;

    public AutoCheckInsuranceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AutoCheckInsuranceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call brickftpCall(String xApiKey, String xAutotecId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/webhook/brickftp";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        if (xAutotecId != null) {
            localVarHeaderParams.put("x-autotec-id", this.apiClient.parameterToString(xAutotecId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"CustomerAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call brickftpValidateBeforeCall(String xApiKey, String xAutotecId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.brickftpCall(xApiKey, xAutotecId, progressListener, progressRequestListener);
        return call;
    }

    public Empty brickftp(String xApiKey, String xAutotecId) throws ApiException {
        ApiResponse<Empty> resp = this.brickftpWithHttpInfo(xApiKey, xAutotecId);
        return resp.getData();
    }

    public ApiResponse<Empty> brickftpWithHttpInfo(String xApiKey, String xAutotecId) throws ApiException {
        Call call = this.brickftpValidateBeforeCall(xApiKey, xAutotecId, null, null);
        Type localVarReturnType = new TypeToken<Empty>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call brickftpAsync(String xApiKey, String xAutotecId, final ApiCallback<Empty> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.brickftpValidateBeforeCall(xApiKey, xAutotecId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Empty>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

