/*
 * AutoCheck Insurance Services API
 * API for methods pertaining to all AutoCheck Insurance services
 *
 * OpenAPI spec version: 2.0.11
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.autocheckinsurance.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.LocalDate;

/**
 * VehicleRiskResult
 */

public class VehicleRiskResult {
  @SerializedName("effectiveEndDate")
  private LocalDate effectiveEndDate = null;

  @SerializedName("referenceNumber")
  private String referenceNumber = null;

  @SerializedName("results")
  private String results = null;

  @SerializedName("vin")
  private String vin = null;

  public VehicleRiskResult effectiveEndDate(LocalDate effectiveEndDate) {
    this.effectiveEndDate = effectiveEndDate;
    return this;
  }

   /**
   * the effective end date
   * @return effectiveEndDate
  **/
  @ApiModelProperty(value = "the effective end date")
  public LocalDate getEffectiveEndDate() {
    return effectiveEndDate;
  }

  public void setEffectiveEndDate(LocalDate effectiveEndDate) {
    this.effectiveEndDate = effectiveEndDate;
  }

  public VehicleRiskResult referenceNumber(String referenceNumber) {
    this.referenceNumber = referenceNumber;
    return this;
  }

   /**
   * the reference number for the caller&#39;s tracking purposes
   * @return referenceNumber
  **/
  @ApiModelProperty(value = "the reference number for the caller's tracking purposes")
  public String getReferenceNumber() {
    return referenceNumber;
  }

  public void setReferenceNumber(String referenceNumber) {
    this.referenceNumber = referenceNumber;
  }

  public VehicleRiskResult results(String results) {
    this.results = results;
    return this;
  }

   /**
   * The risk prediction results. Possible values include:  An integer between 20 and 999.&#39;, &#39;Invalid Date&#39;, &#39;Invalid Type&#39;, &#39;Invalid check-digit: The VIN contains an invalid year for the make and model.&#39;, &#39;Invalid check-digit:&#39;, &#39;Warning the VIN pattern is unknown. * Invalid check-digit: The VIN is greater than 17 characters in length.&#39;, &#39;Invalid check-digit: The VIN is less than 17 characters in length.&#39;
   * @return results
  **/
  @ApiModelProperty(value = "The risk prediction results. Possible values include:  An integer between 20 and 999.', 'Invalid Date', 'Invalid Type', 'Invalid check-digit: The VIN contains an invalid year for the make and model.', 'Invalid check-digit:', 'Warning the VIN pattern is unknown. * Invalid check-digit: The VIN is greater than 17 characters in length.', 'Invalid check-digit: The VIN is less than 17 characters in length.'")
  public String getResults() {
    return results;
  }

  public void setResults(String results) {
    this.results = results;
  }

  public VehicleRiskResult vin(String vin) {
    this.vin = vin;
    return this;
  }

   /**
   * the vehicle identification number
   * @return vin
  **/
  @ApiModelProperty(value = "the vehicle identification number")
  public String getVin() {
    return vin;
  }

  public void setVin(String vin) {
    this.vin = vin;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VehicleRiskResult vehicleRiskResult = (VehicleRiskResult) o;
    return Objects.equals(this.effectiveEndDate, vehicleRiskResult.effectiveEndDate) &&
        Objects.equals(this.referenceNumber, vehicleRiskResult.referenceNumber) &&
        Objects.equals(this.results, vehicleRiskResult.results) &&
        Objects.equals(this.vin, vehicleRiskResult.vin);
  }

  @Override
  public int hashCode() {
    return Objects.hash(effectiveEndDate, referenceNumber, results, vin);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VehicleRiskResult {\n");
    
    sb.append("    effectiveEndDate: ").append(toIndentedString(effectiveEndDate)).append("\n");
    sb.append("    referenceNumber: ").append(toIndentedString(referenceNumber)).append("\n");
    sb.append("    results: ").append(toIndentedString(results)).append("\n");
    sb.append("    vin: ").append(toIndentedString(vin)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

