/*
 * AutoCheck Insurance Services API
 * API for methods pertaining to all AutoCheck Insurance services
 *
 * OpenAPI spec version: 2.0.11
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.autocheckinsurance.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.autocheckinsurance.sdk.model.UnprocessedHistoryRequests;
import com.autocheckinsurance.sdk.model.Vehicle;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * HistoryResponse
 */

public class HistoryResponse {
  @SerializedName("count")
  private Integer count = null;

  /**
   * the history level returned
   */
  @JsonAdapter(LevelEnum.Adapter.class)
  public enum LevelEnum {
    ACCIDENT("ACCIDENT"),
    
    ANNOUNCEMENT("ANNOUNCEMENT"),
    
    CANADIAN("CANADIAN"),
    
    CANADIAN_PLUS("CANADIAN_PLUS"),
    
    COMPROMISED("COMPROMISED"),
    
    DISASTER("DISASTER"),
    
    DISCREPANCY("DISCREPANCY"),
    
    EXCEPTION("EXCEPTION"),
    
    FULL("FULL"),
    
    RECALL("RECALL"),
    
    THEFT("THEFT");

    private String value;

    LevelEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static LevelEnum fromValue(String text) {
      for (LevelEnum b : LevelEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<LevelEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final LevelEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public LevelEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return LevelEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("level")
  private LevelEnum level = null;

  @SerializedName("unprocessed")
  private UnprocessedHistoryRequests unprocessed = null;

  @SerializedName("vehicles")
  private java.util.List<Vehicle> vehicles = null;

  public HistoryResponse count(Integer count) {
    this.count = count;
    return this;
  }

   /**
   * the number of vehicles returned
   * @return count
  **/
  @ApiModelProperty(value = "the number of vehicles returned")
  public Integer getCount() {
    return count;
  }

  public void setCount(Integer count) {
    this.count = count;
  }

  public HistoryResponse level(LevelEnum level) {
    this.level = level;
    return this;
  }

   /**
   * the history level returned
   * @return level
  **/
  @ApiModelProperty(value = "the history level returned")
  public LevelEnum getLevel() {
    return level;
  }

  public void setLevel(LevelEnum level) {
    this.level = level;
  }

  public HistoryResponse unprocessed(UnprocessedHistoryRequests unprocessed) {
    this.unprocessed = unprocessed;
    return this;
  }

   /**
   * Get unprocessed
   * @return unprocessed
  **/
  @ApiModelProperty(value = "")
  public UnprocessedHistoryRequests getUnprocessed() {
    return unprocessed;
  }

  public void setUnprocessed(UnprocessedHistoryRequests unprocessed) {
    this.unprocessed = unprocessed;
  }

  public HistoryResponse vehicles(java.util.List<Vehicle> vehicles) {
    this.vehicles = vehicles;
    return this;
  }

  public HistoryResponse addVehiclesItem(Vehicle vehiclesItem) {
    if (this.vehicles == null) {
      this.vehicles = new java.util.ArrayList<>();
    }
    this.vehicles.add(vehiclesItem);
    return this;
  }

   /**
   * the list of vehicles returned
   * @return vehicles
  **/
  @ApiModelProperty(value = "the list of vehicles returned")
  public java.util.List<Vehicle> getVehicles() {
    return vehicles;
  }

  public void setVehicles(java.util.List<Vehicle> vehicles) {
    this.vehicles = vehicles;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoryResponse historyResponse = (HistoryResponse) o;
    return Objects.equals(this.count, historyResponse.count) &&
        Objects.equals(this.level, historyResponse.level) &&
        Objects.equals(this.unprocessed, historyResponse.unprocessed) &&
        Objects.equals(this.vehicles, historyResponse.vehicles);
  }

  @Override
  public int hashCode() {
    return Objects.hash(count, level, unprocessed, vehicles);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoryResponse {\n");
    
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    level: ").append(toIndentedString(level)).append("\n");
    sb.append("    unprocessed: ").append(toIndentedString(unprocessed)).append("\n");
    sb.append("    vehicles: ").append(toIndentedString(vehicles)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

