/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tools.gzip;

import java.io.Closeable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\r\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/autonomousapps/tools/gzip/GunzipTaskOutput;", "", "fs", "Ljava/nio/file/FileSystem;", "input", "", "output", "(Ljava/nio/file/FileSystem;Ljava/lang/String;Ljava/lang/String;)V", "run", "", "run$dependency_analysis_gradle_plugin", "Companion", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGunzipTaskOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GunzipTaskOutput.kt\ncom/autonomousapps/tools/gzip/GunzipTaskOutput\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public final class GunzipTaskOutput {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileSystem fs;
    @NotNull
    private final String input;
    @NotNull
    private final String output;

    public GunzipTaskOutput(@NotNull FileSystem fs, @NotNull String input, @NotNull String output) {
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.fs = fs;
        this.input = input;
        this.output = output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run$dependency_analysis_gradle_plugin() {
        String string;
        Path input = this.fs.getPath(this.input, new String[0]);
        Path output = this.fs.getPath(this.output, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)input, (String)"input");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(input, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean bl = false;
            String string2 = "Input file does not exist. Expected " + ((Object)input.toAbsolutePath()).toString();
            throw new IllegalArgumentException(string2.toString());
        }
        System.out.println((Object)("Processing file input '" + input + "'"));
        System.out.println((Object)("Writing output to '" + output + "'"));
        Closeable closeable = (Closeable)Okio.buffer((Source)((Source)new GzipSource(Okio.source((Path)input, (OpenOption[])new OpenOption[0]))));
        Throwable throwable = null;
        try {
            BufferedSource source = (BufferedSource)closeable;
            boolean bl = false;
            string = source.readUtf8();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String decompressed = string;
        Intrinsics.checkNotNullExpressionValue((Object)output, (String)"output");
        PathsKt.writeText$default((Path)output, (CharSequence)decompressed, null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    @JvmStatic
    public static final void main(String ... args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/autonomousapps/tools/gzip/GunzipTaskOutput$Companion;", "", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nGunzipTaskOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GunzipTaskOutput.kt\ncom/autonomousapps/tools/gzip/GunzipTaskOutput$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(String ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (!(args.length == 2)) {
                boolean bl = false;
                String string = "Expected two arguments. Was " + ArraysKt.joinToString$default((Object[])args, null, null, null, (int)0, null, null, (int)63, null);
                throw new IllegalArgumentException(string.toString());
            }
            FileSystem fileSystem = FileSystems.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"getDefault()");
            new GunzipTaskOutput(fileSystem, args[0], args[1]).run$dependency_analysis_gradle_plugin();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

