/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.graph.GraphViewBuilder;
import com.autonomousapps.internal.graph.GraphWriter;
import com.autonomousapps.internal.graph.GraphsKt;
import com.autonomousapps.internal.utils.GraphAdapter;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Coordinates;
import com.google.common.graph.Graph;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import java.io.Closeable;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/autonomousapps/tasks/GenerateProjectGraphTask;", "Lorg/gradle/api/DefaultTask;", "()V", "buildPath", "Lorg/gradle/api/provider/Property;", "", "getBuildPath", "()Lorg/gradle/api/provider/Property;", "compileClasspath", "Lorg/gradle/api/artifacts/result/ResolvedComponentResult;", "getCompileClasspath", "output", "Lorg/gradle/api/file/DirectoryProperty;", "getOutput", "()Lorg/gradle/api/file/DirectoryProperty;", "runtimeClasspath", "getRuntimeClasspath", "action", "", "Companion", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGenerateProjectGraphTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateProjectGraphTask.kt\ncom/autonomousapps/tasks/GenerateProjectGraphTask\n+ 2 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n*L\n1#1,79:1\n176#2,3:80\n40#2,2:83\n33#2,4:85\n179#2,2:89\n*S KotlinDebug\n*F\n+ 1 GenerateProjectGraphTask.kt\ncom/autonomousapps/tasks/GenerateProjectGraphTask\n*L\n72#1:80,3\n72#1:83,2\n72#1:85,4\n72#1:89,2\n*E\n"})
public abstract class GenerateProjectGraphTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PROJECT_COMBINED_CLASSPATH_JSON = "project-combined-classpath.json";
    @NotNull
    public static final String PROJECT_COMPILE_CLASSPATH_GV = "project-compile-classpath.gv";
    @NotNull
    public static final String PROJECT_RUNTIME_CLASSPATH_GV = "project-runtime-classpath.gv";
    @NotNull
    public static final String PROJECT_COMBINED_CLASSPATH_GV = "project-combined-classpath.gv";

    public GenerateProjectGraphTask() {
        this.setDescription("Generates several graph views of this project's local dependency graph");
    }

    @Input
    @NotNull
    public abstract Property<String> getBuildPath();

    @Input
    @NotNull
    public abstract Property<ResolvedComponentResult> getCompileClasspath();

    @Input
    @NotNull
    public abstract Property<ResolvedComponentResult> getRuntimeClasspath();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutput();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        void $this$bufferWriteJson_u24default$iv;
        Provider provider = this.getOutput().file(PROJECT_COMPILE_CLASSPATH_GV);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"output.file(PROJECT_COMPILE_CLASSPATH_GV)");
        File compileOutput = UtilsKt.getAndDelete((Provider<RegularFile>)provider);
        Provider provider2 = this.getOutput().file(PROJECT_RUNTIME_CLASSPATH_GV);
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"output.file(PROJECT_RUNTIME_CLASSPATH_GV)");
        File runtimeOutput = UtilsKt.getAndDelete((Provider<RegularFile>)provider2);
        Provider provider3 = this.getOutput().file(PROJECT_COMBINED_CLASSPATH_GV);
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"output.file(PROJECT_COMBINED_CLASSPATH_GV)");
        File combinedOutput = UtilsKt.getAndDelete((Provider<RegularFile>)provider3);
        Provider provider4 = this.getOutput().file(PROJECT_COMBINED_CLASSPATH_JSON);
        Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"output.file(PROJECT_COMBINED_CLASSPATH_JSON)");
        File combinedJsonOutput = UtilsKt.getAndDelete((Provider<RegularFile>)provider4);
        Provider provider5 = this.getOutput().file("project-compile-classpath-topological.txt");
        Intrinsics.checkNotNullExpressionValue((Object)provider5, (String)"output.file(\"project-com\u2026asspath-topological.txt\")");
        File compileTopOutput = UtilsKt.getAndDelete((Provider<RegularFile>)provider5);
        Provider provider6 = this.getOutput().file("project-runtime-classpath-topological.txt");
        Intrinsics.checkNotNullExpressionValue((Object)provider6, (String)"output.file(\"project-run\u2026asspath-topological.txt\")");
        File runtimeTopOutput = UtilsKt.getAndDelete((Provider<RegularFile>)provider6);
        Object object = this.getCompileClasspath().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compileClasspath.get()");
        Graph<Coordinates> compileGraph = new GraphViewBuilder((ResolvedComponentResult)object, SetsKt.emptySet(), true).getGraph();
        Object object2 = this.getRuntimeClasspath().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"runtimeClasspath.get()");
        Graph<Coordinates> runtimeGraph = new GraphViewBuilder((ResolvedComponentResult)object2, SetsKt.emptySet(), true).getGraph();
        Object object3 = this.getBuildPath().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"buildPath.get()");
        GraphWriter graphWriter = new GraphWriter((String)object3);
        Object object4 = this.getBuildPath().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"buildPath.get()");
        String buildPath2 = (String)object4;
        FilesKt.writeText$default((File)compileOutput, (String)graphWriter.toDot(compileGraph), null, (int)2, null);
        FilesKt.writeText$default((File)runtimeOutput, (String)graphWriter.toDot(runtimeGraph), null, (int)2, null);
        Graph<Coordinates> combinedGraph = GraphsKt.plus(GraphsKt.stripVariants(compileGraph, buildPath2), GraphsKt.stripVariants(runtimeGraph, buildPath2));
        FilesKt.writeText$default((File)combinedOutput, (String)graphWriter.toDot(combinedGraph), null, (int)2, null);
        File file = combinedJsonOutput;
        GraphAdapter.GraphContainer obj$iv = new GraphAdapter.GraphContainer(combinedGraph);
        String indent$iv = "";
        boolean $i$f$bufferWriteJson = false;
        Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJson_u24default$iv, (boolean)false, (int)1, null)));
        Throwable throwable = null;
        try {
            JsonWriter writer$iv = (JsonWriter)closeable;
            boolean bl = false;
            boolean withNulls$iv$iv = false;
            boolean $i$f$getJsonAdapter = false;
            JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(GraphAdapter.GraphContainer.class);
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter(T::class.java)");
            JsonAdapter $this$withNulls$iv$iv$iv = jsonAdapter;
            boolean $i$f$withNulls = false;
            $this$withNulls$iv$iv$iv.indent(indent$iv).toJson(writer$iv, (Object)obj$iv);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        FilesKt.writeText$default((File)compileTopOutput, (String)graphWriter.topological(compileGraph), null, (int)2, null);
        FilesKt.writeText$default((File)runtimeTopOutput, (String)graphWriter.topological(runtimeGraph), null, (int)2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/autonomousapps/tasks/GenerateProjectGraphTask$Companion;", "", "()V", "PROJECT_COMBINED_CLASSPATH_GV", "", "PROJECT_COMBINED_CLASSPATH_JSON", "PROJECT_COMPILE_CLASSPATH_GV", "PROJECT_RUNTIME_CLASSPATH_GV", "dependency-analysis-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

