/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.utils.ResolvedDependenciesKt;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.internal.utils.VersionCatalogKt;
import com.autonomousapps.model.ModuleCoordinates;
import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/autonomousapps/tasks/ComputeAllDependenciesTask;", "Lorg/gradle/api/DefaultTask;", "()V", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "resolvedDependenciesReports", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getResolvedDependenciesReports", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "action", "", "dependency-analysis-gradle-plugin"})
public abstract class ComputeAllDependenciesTask
extends DefaultTask {
    public ComputeAllDependenciesTask() {
        this.setGroup("dependency-analysis");
        this.setDescription("Generates a version catalog file (allLibs.versions.toml) containing all dependencies in the project.");
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getResolvedDependenciesReports();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @TaskAction
    public final void action() {
        File outputFile = UtilsKt.getAndDelete(this.getOutput());
        Set<ModuleCoordinates> libs = ResolvedDependenciesKt.dependencyCoordinates(this.getResolvedDependenciesReports());
        FilesKt.writeText$default((File)outputFile, (String)VersionCatalogKt.toVersionCatalog(libs), null, (int)2, null);
        this.getLogger().quiet("Generated version catalog for all dependencies, containing " + libs.size() + " entries:\n" + outputFile.getAbsolutePath() + " ");
    }
}

