/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.rest;

import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RestRequest
extends Request<JSONObject> {
    public static final String USER_AGENT_HEADER = "User-Agent";
    public static final String REST_AUTHORIZATION_HEADER = "Authorization";
    public static final String REST_AUTHORIZATION_FORMAT = "Bearer %s";
    private static OnAuthFailedListener mOnAuthFailedListener;
    private final Response.Listener<JSONObject> mListener;
    private final Map<String, String> mParams;
    private final Map<String, String> mHeaders = new HashMap<String, String>(2);

    public RestRequest(int method, String url, Map<String, String> params, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener) {
        super(method, url, errorListener);
        this.mParams = params;
        this.mListener = listener;
    }

    public void removeAccessToken() {
        this.setAccessToken(null);
    }

    public void setAccessToken(String token) {
        if (token == null) {
            this.mHeaders.remove(REST_AUTHORIZATION_HEADER);
        } else {
            this.mHeaders.put(REST_AUTHORIZATION_HEADER, String.format(REST_AUTHORIZATION_FORMAT, token));
        }
    }

    public void setUserAgent(String userAgent) {
        this.mHeaders.put(USER_AGENT_HEADER, userAgent);
    }

    public void setOnAuthFailedListener(OnAuthFailedListener onAuthFailedListener) {
        mOnAuthFailedListener = onAuthFailedListener;
    }

    public Map<String, String> getHeaders() {
        return this.mHeaders;
    }

    protected void deliverResponse(JSONObject response) {
        if (this.mListener != null) {
            this.mListener.onResponse((Object)response);
        }
    }

    protected Map<String, String> getParams() {
        return this.mParams;
    }

    public void deliverError(VolleyError error) {
        super.deliverError(error);
        if (error.networkResponse != null && error.networkResponse.statusCode >= 400 && mOnAuthFailedListener != null) {
            JSONObject responseObject;
            String jsonString;
            try {
                jsonString = new String(error.networkResponse.data, HttpHeaderParser.parseCharset((Map)error.networkResponse.headers));
            }
            catch (UnsupportedEncodingException e) {
                jsonString = "";
            }
            try {
                responseObject = new JSONObject(jsonString);
            }
            catch (JSONException e) {
                responseObject = new JSONObject();
            }
            String restError = responseObject.optString("error", "");
            if (restError.equals("authorization_required") || restError.equals("invalid_token")) {
                mOnAuthFailedListener.onAuthFailed();
            }
        }
    }

    protected Response<JSONObject> parseNetworkResponse(NetworkResponse response) {
        try {
            String jsonString = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers));
            try {
                return Response.success((Object)new JSONObject(jsonString), (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
            }
            catch (JSONException parseErr) {
                JSONArray responseArray = new JSONArray(jsonString);
                JSONObject wrapper = new JSONObject();
                wrapper.put("originalResponse", (Object)responseArray);
                return Response.success((Object)wrapper, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
            }
        }
        catch (UnsupportedEncodingException e) {
            return Response.error((VolleyError)new ParseError((Throwable)e));
        }
        catch (JSONException je) {
            return Response.error((VolleyError)new ParseError((Throwable)je));
        }
    }

    public static interface OnAuthFailedListener {
        public void onAuthFailed();
    }

    public static interface ErrorListener
    extends Response.ErrorListener {
    }

    public static interface Listener
    extends Response.Listener<JSONObject> {
    }
}

