/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.rest;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.wordpress.rest.JsonRestRequest;
import com.wordpress.rest.RestRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.json.JSONObject;

public class RestClient {
    public static final String TAG = "WordPressREST";
    public static final String PARAMS_ENCODING = "UTF-8";
    protected static final String REST_API_ENDPOINT_URL_V1 = "https://public-api.wordpress.com/rest/v1/";
    protected static final String REST_API_ENDPOINT_URL_V1_1 = "https://public-api.wordpress.com/rest/v1.1/";
    protected static final String REST_API_ENDPOINT_URL_V1_2 = "https://public-api.wordpress.com/rest/v1.2/";
    protected static final String REST_API_ENDPOINT_URL_V1_3 = "https://public-api.wordpress.com/rest/v1.3/";
    private RequestQueue mQueue;
    private String mAccessToken;
    private String mUserAgent;
    private String mRestApiEndpointURL;
    private RestRequest.OnAuthFailedListener mOnAuthFailedListener;

    public RestClient(RequestQueue queue) {
        this(queue, REST_CLIENT_VERSIONS.V1);
    }

    public RestClient(RequestQueue queue, REST_CLIENT_VERSIONS version) {
        this.mQueue = queue;
        this.mRestApiEndpointURL = version == REST_CLIENT_VERSIONS.V1_3 ? REST_API_ENDPOINT_URL_V1_3 : (version == REST_CLIENT_VERSIONS.V1_2 ? REST_API_ENDPOINT_URL_V1_2 : (version == REST_CLIENT_VERSIONS.V1_1 ? REST_API_ENDPOINT_URL_V1_1 : REST_API_ENDPOINT_URL_V1));
    }

    public RestClient(RequestQueue queue, String token, String endpointURL) {
        this(queue);
        this.mAccessToken = token;
        this.mRestApiEndpointURL = endpointURL;
    }

    public RestRequest get(String path, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener) {
        return this.makeRequest(0, this.getAbsoluteURL(path), null, listener, errorListener);
    }

    public RestRequest post(String path, Map<String, String> body, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener) {
        return this.makeRequest(1, this.getAbsoluteURL(path), body, listener, errorListener);
    }

    public RestRequest makeRequest(int method, String url, Map<String, String> params, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener) {
        RestRequest request = new RestRequest(method, url, params, listener, errorListener);
        if (this.mOnAuthFailedListener != null) {
            request.setOnAuthFailedListener(this.mOnAuthFailedListener);
        }
        request.setUserAgent(this.mUserAgent);
        request.setAccessToken(this.mAccessToken);
        return request;
    }

    public JsonRestRequest makeRequest(String url, JSONObject params, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener) {
        JsonRestRequest request = new JsonRestRequest(url, params, listener, errorListener);
        if (this.mOnAuthFailedListener != null) {
            request.setOnAuthFailedListener(this.mOnAuthFailedListener);
        }
        request.setUserAgent(this.mUserAgent);
        request.setAccessToken(this.mAccessToken);
        return request;
    }

    public RestRequest send(RestRequest request) {
        this.mQueue.add((Request)request);
        return request;
    }

    public void setOnAuthFailedListener(RestRequest.OnAuthFailedListener onAuthFailedListener) {
        this.mOnAuthFailedListener = onAuthFailedListener;
    }

    public String getAbsoluteURL(String url) {
        if (url.indexOf(this.mRestApiEndpointURL) == 0) {
            return url;
        }
        if (url.indexOf("/") == 0) {
            url = url.substring(1);
        }
        return String.format("%s%s", this.mRestApiEndpointURL, url);
    }

    public String getAbsoluteURL(String path, Map<String, String> params) {
        String url = this.getAbsoluteURL(path);
        if (params != null) {
            StringBuilder query = new StringBuilder();
            try {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    query.append(URLEncoder.encode(entry.getKey(), PARAMS_ENCODING));
                    query.append("=");
                    query.append(URLEncoder.encode(entry.getValue(), PARAMS_ENCODING));
                    query.append("&");
                }
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException("Encoding not supported: UTF-8", uee);
            }
            url = String.format("%s?%s", url, query);
        }
        return url;
    }

    public void setUserAgent(String userAgent) {
        this.mUserAgent = userAgent;
    }

    public void setAccessToken(String token) {
        this.mAccessToken = token;
    }

    public boolean isAuthenticated() {
        return this.mAccessToken != null;
    }

    public String getEndpointURL() {
        return this.mRestApiEndpointURL;
    }

    public static enum REST_CLIENT_VERSIONS {
        V1,
        V1_1,
        V1_2,
        V1_3;

    }
}

