/*
 * Decompiled with CFR 0.152.
 */
package com.authy.api;

import com.authy.api.Error;
import com.authy.api.Formattable;
import com.authy.api.Hash;
import com.authy.api.Resource;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.json.JSONObject;

public class Users
extends Resource {
    public static final String NEW_USER_PATH = "/protected/xml/users/new";
    public static final String DELETE_USER_PATH = "/protected/xml/users/delete/";
    public static final String SMS_PATH = "/protected/xml/sms/";
    public static final String ONE_CODE_CALL_PATH = "/protected/xml/call/";
    public static final String DEFAULT_COUNTRY_CODE = "1";

    public Users(String uri, String key) {
        super(uri, key);
    }

    public Users(String uri, String key, boolean testFlag) {
        super(uri, key, testFlag);
    }

    public com.authy.api.User createUser(String email, String phone, String countryCode) {
        User user = new User(email, phone, countryCode);
        String content = this.post(NEW_USER_PATH, user);
        return this.userFromXml(this.getStatus(), content);
    }

    public com.authy.api.User createUser(String email, String phone) {
        return this.createUser(email, phone, DEFAULT_COUNTRY_CODE);
    }

    public Hash requestSms(int userId) {
        return this.requestSms(userId, new HashMap<String, String>(0));
    }

    public Hash requestSms(int userId, Map<String, String> options) {
        String url = "";
        try {
            url = URLEncoder.encode(Integer.toString(userId), "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MapToResponse opt = new MapToResponse(options);
        String content = this.get(SMS_PATH + url, opt);
        return this.instanceFromXml(this.getStatus(), content);
    }

    public Hash requestCall(int userId) {
        return this.requestCall(userId, new HashMap<String, String>(0));
    }

    public Hash requestCall(int userId, Map<String, String> options) {
        String url = "";
        try {
            url = URLEncoder.encode(Integer.toString(userId), "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MapToResponse opt = new MapToResponse(options);
        String content = this.get(ONE_CODE_CALL_PATH + url, opt);
        return this.instanceFromXml(this.getStatus(), content);
    }

    public Hash deleteUser(int userId) {
        String url = "";
        try {
            url = URLEncoder.encode(Integer.toString(userId), "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String content = this.post(DELETE_USER_PATH + url, null);
        return this.instanceFromXml(this.getStatus(), content);
    }

    private com.authy.api.User userFromXml(int status, String content) {
        com.authy.api.User user = new com.authy.api.User();
        try {
            Error error = this.errorFromXml(status, content);
            if (error == null) {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Hash.class});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                StringReader xml = new StringReader(content);
                Hash hash = (Hash)unmarshaller.unmarshal((Source)new StreamSource(xml));
                user = hash.getUser();
                user.message = hash.getMessage();
            }
            user.status = status;
            user.setError(error);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return user;
    }

    private Error errorFromXml(int status, String content) {
        Error error = new Error();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Error.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            StringReader xml = new StringReader(content);
            error = (Error)unmarshaller.unmarshal((Source)new StreamSource(xml));
        }
        catch (JAXBException e) {
            return null;
        }
        return error;
    }

    private Hash instanceFromXml(int status, String content) {
        Hash hash = new Hash();
        try {
            Error error = this.errorFromXml(status, content);
            if (error == null) {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Hash.class});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                StringReader xml = new StringReader(content);
                hash = (Hash)unmarshaller.unmarshal((Source)new StreamSource(xml));
            }
            hash.setStatus(status);
            hash.setError(error);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return hash;
    }

    @XmlRootElement(name="user")
    static class User
    implements Formattable {
        String email;
        String cellphone;
        String countryCode;

        public User() {
        }

        public User(String email, String cellphone, String countryCode) {
            this.email = email;
            this.cellphone = cellphone;
            this.countryCode = countryCode;
        }

        @XmlElement(name="email")
        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        @XmlElement(name="cellphone")
        public String getCellphone() {
            return this.cellphone;
        }

        public void setCellphone(String cellphone) {
            this.cellphone = cellphone;
        }

        @XmlElement(name="country_code")
        public String getCountryCode() {
            return this.countryCode;
        }

        public void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public String toXML() {
            StringWriter sw = new StringWriter();
            String xml = "";
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{this.getClass()});
                Marshaller marshaller = context.createMarshaller();
                marshaller.marshal((Object)this, (Writer)sw);
                xml = sw.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return xml;
        }

        @Override
        public Map<String, String> toMap() {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("email", this.email);
            map.put("cellphone", this.cellphone);
            map.put("countryCode", this.countryCode);
            return map;
        }

        @Override
        public String toJSON() {
            return new JSONObject(this.toMap()).toString();
        }
    }

    static class MapToResponse
    implements Formattable {
        private Map<String, String> options;

        public MapToResponse(Map<String, String> options) {
            this.options = options;
        }

        @Override
        public String toXML() {
            return "";
        }

        @Override
        public Map<String, String> toMap() {
            return this.options;
        }

        @Override
        public String toJSON() {
            return new JSONObject(this.toMap()).toString();
        }
    }
}

