/*
 * Decompiled with CFR 0.152.
 */
package com.authy.api;

import com.authy.api.Formattable;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class PhoneInfoResponse
implements Formattable {
    private int status = 503;
    private String response;
    private String message = "Something went wrong!";
    private String provider = "";
    private String type = "";
    private boolean isPorted = false;

    public PhoneInfoResponse() {
    }

    public PhoneInfoResponse(int status, String response, String message) {
        this.status = status;
        this.response = response;
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getType() {
        return this.type;
    }

    public String getSuccess() {
        return Boolean.toString(this.isOk());
    }

    public String getIsPorted() {
        return Boolean.toString(this.isPorted);
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setResponse(String response) {
        this.response = response;
        JSONObject jsonResponse = new JSONObject(response);
        this.parseResponseToOjbect(jsonResponse);
    }

    public boolean isOk() {
        return this.status == 200;
    }

    @Override
    public String toXML() {
        return "";
    }

    @Override
    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("message", this.getMessage());
        map.put("success", this.getSuccess());
        map.put("is_ported", this.getIsPorted());
        map.put("provider", this.getProvider());
        map.put("type", this.getType());
        return map;
    }

    @Override
    public String toJSON() {
        JSONObject info = new JSONObject();
        info.put("message", (Object)this.getMessage());
        info.put("success", (Object)this.getSuccess());
        info.put("is_ported", (Object)this.getIsPorted());
        info.put("provider", (Object)this.getProvider());
        info.put("type", (Object)this.getType());
        return info.toString();
    }

    private void parseResponseToOjbect(JSONObject json) {
        if (!json.isNull("message")) {
            this.message = json.getString("message");
        }
        if (!json.isNull("ported")) {
            this.isPorted = json.getBoolean("ported");
        }
        if (!json.isNull("provider")) {
            this.provider = json.getString("provider");
        }
        if (!json.isNull("type")) {
            this.type = json.getString("type");
        }
    }
}

