/*
 * Decompiled with CFR 0.152.
 */
package com.aurelhubert.ahbottomnavigation;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.aurelhubert.ahbottomnavigation.AHBottomNavigationBehavior;
import com.aurelhubert.ahbottomnavigation.AHBottomNavigationItem;
import com.aurelhubert.ahbottomnavigation.AHHelper;
import com.aurelhubert.ahbottomnavigation.R;
import java.util.ArrayList;
import java.util.List;

public class AHBottomNavigation
extends FrameLayout {
    public static final int CURRENT_ITEM_NONE = -1;
    public static final int UPDATE_ALL_NOTIFICATIONS = -1;
    private static String TAG = "AHBottomNavigation";
    private static final int MIN_ITEMS = 3;
    private static final int MAX_ITEMS = 5;
    private AHBottomNavigationListener listener;
    private OnTabSelectedListener tabSelectedListener;
    private Context context;
    private Resources resources;
    private ArrayList<AHBottomNavigationItem> items = new ArrayList();
    private ArrayList<View> views = new ArrayList();
    private AHBottomNavigationBehavior<AHBottomNavigation> bottomNavigationBehavior;
    private View backgroundColorView;
    private boolean colored = false;
    private int[] notifications = new int[]{0, 0, 0, 0, 0};
    private boolean isBehaviorTranslationSet = false;
    private int defaultBackgroundColor = -1;
    private int accentColor = -1;
    private int inactiveColor = -1;
    private int currentItem = 0;
    private int currentColor = 0;
    private int bottomNavigationHeight;
    private float selectedItemWidth;
    private float notSelectedItemWidth;
    private boolean behaviorTranslationEnabled = true;
    private boolean forceTint = false;
    private boolean forceTitlesDisplay = false;
    private boolean needHideBottomNavigation = false;
    @ColorInt
    private int notificationTextColor;
    @ColorInt
    private int notificationBackgroundColor;
    private Drawable notificationBackgroundDrawable;
    private Typeface notificationTypeface;

    public AHBottomNavigation(Context context) {
        super(context);
        this.init(context);
    }

    public AHBottomNavigation(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AHBottomNavigation(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.createItems();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.isBehaviorTranslationSet) {
            this.setBehaviorTranslationEnabled(this.behaviorTranslationEnabled);
            this.isBehaviorTranslationSet = true;
        }
    }

    private void init(Context context) {
        this.context = context;
        this.resources = this.context.getResources();
        this.accentColor = ContextCompat.getColor((Context)this.context, (int)R.color.colorAccent);
        this.inactiveColor = ContextCompat.getColor((Context)this.context, (int)R.color.colorInactive);
        this.notificationTextColor = ContextCompat.getColor((Context)this.context, (int)17170443);
        this.bottomNavigationHeight = (int)this.resources.getDimension(R.dimen.bottom_navigation_height);
        ViewCompat.setElevation((View)this, (float)this.resources.getDimension(R.dimen.bottom_navigation_elevation));
        this.setClipToPadding(false);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, this.bottomNavigationHeight);
        this.setLayoutParams(params);
    }

    private void createItems() {
        if (this.items.size() < 3) {
            Log.w((String)TAG, (String)"The items list should have at least 3 items");
        } else if (this.items.size() > 5) {
            Log.w((String)TAG, (String)"The items list should not have more than 5 items");
        }
        int layoutHeight = (int)this.resources.getDimension(R.dimen.bottom_navigation_height);
        this.removeAllViews();
        this.views.clear();
        this.backgroundColorView = new View(this.context);
        if (Build.VERSION.SDK_INT >= 21) {
            FrameLayout.LayoutParams backgroundLayoutParams = new FrameLayout.LayoutParams(-1, layoutHeight);
            this.addView(this.backgroundColorView, (ViewGroup.LayoutParams)backgroundLayoutParams);
        }
        LinearLayout linearLayout = new LinearLayout(this.context);
        linearLayout.setOrientation(0);
        linearLayout.setGravity(17);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, layoutHeight);
        this.addView((View)linearLayout, (ViewGroup.LayoutParams)layoutParams);
        if (this.items.size() == 3 || this.forceTitlesDisplay) {
            this.createClassicItems(linearLayout);
        } else {
            this.createSmallItems(linearLayout);
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                AHBottomNavigation.this.requestLayout();
            }
        });
    }

    private void createClassicItems(LinearLayout linearLayout) {
        int layoutWidth;
        LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        float height = this.resources.getDimension(R.dimen.bottom_navigation_height);
        float minWidth = this.resources.getDimension(R.dimen.bottom_navigation_min_width);
        float maxWidth = this.resources.getDimension(R.dimen.bottom_navigation_max_width);
        if (this.forceTitlesDisplay && this.items.size() > 3) {
            minWidth = this.resources.getDimension(R.dimen.bottom_navigation_small_inactive_min_width);
            maxWidth = this.resources.getDimension(R.dimen.bottom_navigation_small_inactive_max_width);
        }
        if ((layoutWidth = this.getWidth()) == 0 || this.items.size() == 0) {
            return;
        }
        float itemWidth = layoutWidth / this.items.size();
        if (itemWidth < minWidth) {
            itemWidth = minWidth;
        } else if (itemWidth > maxWidth) {
            itemWidth = maxWidth;
        }
        float activeSize = this.resources.getDimension(R.dimen.bottom_navigation_text_size_active);
        float inactiveSize = this.resources.getDimension(R.dimen.bottom_navigation_text_size_inactive);
        int activePaddingTop = (int)this.resources.getDimension(R.dimen.bottom_navigation_margin_top_active);
        int notificationActiveMarginLeft = (int)this.resources.getDimension(R.dimen.bottom_navigation_notification_margin_left_active);
        if (this.forceTitlesDisplay && this.items.size() > 3) {
            activeSize = this.resources.getDimension(R.dimen.bottom_navigation_text_size_forced_active);
            inactiveSize = this.resources.getDimension(R.dimen.bottom_navigation_text_size_forced_inactive);
        }
        for (int i = 0; i < this.items.size(); ++i) {
            final int itemIndex = i;
            AHBottomNavigationItem item = this.items.get(itemIndex);
            View view = inflater.inflate(R.layout.bottom_navigation_item, (ViewGroup)this, false);
            FrameLayout container = (FrameLayout)view.findViewById(R.id.bottom_navigation_container);
            ImageView icon = (ImageView)view.findViewById(R.id.bottom_navigation_item_icon);
            TextView title = (TextView)view.findViewById(R.id.bottom_navigation_item_title);
            TextView notification = (TextView)view.findViewById(R.id.bottom_navigation_notification);
            icon.setImageDrawable(item.getDrawable(this.context));
            title.setText((CharSequence)item.getTitle(this.context));
            if (this.forceTitlesDisplay && this.items.size() > 3) {
                container.setPadding(0, container.getPaddingTop(), 0, container.getPaddingBottom());
            }
            if (i == this.currentItem && view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)icon.getLayoutParams();
                p.setMargins(p.leftMargin, activePaddingTop, p.rightMargin, p.bottomMargin);
                ViewGroup.MarginLayoutParams paramsNotification = (ViewGroup.MarginLayoutParams)notification.getLayoutParams();
                paramsNotification.setMargins(notificationActiveMarginLeft, paramsNotification.topMargin, paramsNotification.rightMargin, paramsNotification.bottomMargin);
                view.requestLayout();
            }
            if (this.colored) {
                if (i == this.currentItem) {
                    this.setBackgroundColor(item.getColor(this.context));
                    this.currentColor = item.getColor(this.context);
                }
                icon.setImageDrawable(AHHelper.getTintDrawable(this.items.get(i).getDrawable(this.context), this.currentItem == i ? ContextCompat.getColor((Context)this.context, (int)R.color.colorActiveSmall) : ContextCompat.getColor((Context)this.context, (int)R.color.colorInactiveSmall), this.forceTint));
                title.setTextColor(this.currentItem == i ? ContextCompat.getColor((Context)this.context, (int)R.color.colorActiveSmall) : ContextCompat.getColor((Context)this.context, (int)R.color.colorInactiveSmall));
            } else {
                this.setBackgroundColor(this.defaultBackgroundColor);
                icon.setImageDrawable(AHHelper.getTintDrawable(this.items.get(i).getDrawable(this.context), this.currentItem == i ? this.accentColor : this.inactiveColor, this.forceTint));
                title.setTextColor(this.currentItem == i ? this.accentColor : this.inactiveColor);
            }
            title.setTextSize(0, this.currentItem == i ? activeSize : inactiveSize);
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AHBottomNavigation.this.updateItems(itemIndex, true);
                }
            });
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams((int)itemWidth, (int)height);
            linearLayout.addView(view, (ViewGroup.LayoutParams)params);
            this.views.add(view);
        }
        this.updateNotifications(true, -1);
    }

    private void createSmallItems(LinearLayout linearLayout) {
        LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        float height = this.resources.getDimension(R.dimen.bottom_navigation_height);
        float minWidth = this.resources.getDimension(R.dimen.bottom_navigation_small_inactive_min_width);
        float maxWidth = this.resources.getDimension(R.dimen.bottom_navigation_small_inactive_max_width);
        int layoutWidth = this.getWidth();
        if (layoutWidth == 0 || this.items.size() == 0) {
            return;
        }
        float itemWidth = layoutWidth / this.items.size();
        if (itemWidth < minWidth) {
            itemWidth = minWidth;
        } else if (itemWidth > maxWidth) {
            itemWidth = maxWidth;
        }
        int activeMarginTop = (int)this.resources.getDimension(R.dimen.bottom_navigation_small_margin_top_active);
        int notificationActiveMarginLeft = (int)this.resources.getDimension(R.dimen.bottom_navigation_notification_margin_left_active);
        float difference = this.resources.getDimension(R.dimen.bottom_navigation_small_selected_width_difference);
        this.selectedItemWidth = itemWidth + (float)this.items.size() * difference;
        this.notSelectedItemWidth = itemWidth -= difference;
        for (int i = 0; i < this.items.size(); ++i) {
            final int itemIndex = i;
            AHBottomNavigationItem item = this.items.get(itemIndex);
            View view = inflater.inflate(R.layout.bottom_navigation_small_item, (ViewGroup)this, false);
            ImageView icon = (ImageView)view.findViewById(R.id.bottom_navigation_small_item_icon);
            TextView title = (TextView)view.findViewById(R.id.bottom_navigation_small_item_title);
            TextView notification = (TextView)view.findViewById(R.id.bottom_navigation_notification);
            icon.setImageDrawable(item.getDrawable(this.context));
            title.setText((CharSequence)item.getTitle(this.context));
            if (i == this.currentItem && view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)icon.getLayoutParams();
                p.setMargins(p.leftMargin, activeMarginTop, p.rightMargin, p.bottomMargin);
                ViewGroup.MarginLayoutParams paramsNotification = (ViewGroup.MarginLayoutParams)notification.getLayoutParams();
                paramsNotification.setMargins(notificationActiveMarginLeft, paramsNotification.topMargin, paramsNotification.rightMargin, paramsNotification.bottomMargin);
                view.requestLayout();
            }
            if (this.colored) {
                if (i == this.currentItem) {
                    this.setBackgroundColor(item.getColor(this.context));
                    this.currentColor = item.getColor(this.context);
                }
                icon.setImageDrawable(AHHelper.getTintDrawable(this.items.get(i).getDrawable(this.context), this.currentItem == i ? ContextCompat.getColor((Context)this.context, (int)R.color.colorActiveSmall) : ContextCompat.getColor((Context)this.context, (int)R.color.colorInactiveSmall), this.forceTint));
                title.setTextColor(this.currentItem == i ? ContextCompat.getColor((Context)this.context, (int)R.color.colorActiveSmall) : ContextCompat.getColor((Context)this.context, (int)R.color.colorInactiveSmall));
            } else {
                this.setBackgroundColor(this.defaultBackgroundColor);
                icon.setImageDrawable(AHHelper.getTintDrawable(this.items.get(i).getDrawable(this.context), this.currentItem == i ? this.accentColor : this.inactiveColor, this.forceTint));
                title.setTextColor(this.currentItem == i ? this.accentColor : this.inactiveColor);
            }
            title.setAlpha(this.currentItem == i ? 1.0f : 0.0f);
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AHBottomNavigation.this.updateSmallItems(itemIndex, true);
                }
            });
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(i == this.currentItem ? (int)this.selectedItemWidth : (int)itemWidth, (int)height);
            linearLayout.addView(view, (ViewGroup.LayoutParams)params);
            this.views.add(view);
        }
        this.updateNotifications(true, -1);
    }

    private void updateItems(final int itemIndex, boolean useCallback) {
        if (this.currentItem == itemIndex) {
            if (this.tabSelectedListener != null && useCallback) {
                this.tabSelectedListener.onTabSelected(itemIndex, true);
            }
            return;
        }
        int activeMarginTop = (int)this.resources.getDimension(R.dimen.bottom_navigation_margin_top_active);
        int inactiveMarginTop = (int)this.resources.getDimension(R.dimen.bottom_navigation_margin_top_inactive);
        int notificationActiveMarginLeft = (int)this.resources.getDimension(R.dimen.bottom_navigation_notification_margin_left_active);
        int notificationInactiveMarginLeft = (int)this.resources.getDimension(R.dimen.bottom_navigation_notification_margin_left);
        float activeSize = this.resources.getDimension(R.dimen.bottom_navigation_text_size_active);
        float inactiveSize = this.resources.getDimension(R.dimen.bottom_navigation_text_size_inactive);
        if (this.forceTitlesDisplay && this.items.size() > 3) {
            activeSize = this.resources.getDimension(R.dimen.bottom_navigation_text_size_forced_active);
            inactiveSize = this.resources.getDimension(R.dimen.bottom_navigation_text_size_forced_inactive);
        }
        int itemActiveColor = this.colored ? ContextCompat.getColor((Context)this.context, (int)R.color.colorActiveSmall) : this.accentColor;
        int itemInactiveColor = this.colored ? ContextCompat.getColor((Context)this.context, (int)R.color.colorInactiveSmall) : this.inactiveColor;
        for (int i = 0; i < this.views.size(); ++i) {
            TextView notification;
            ImageView icon;
            TextView title;
            if (i == itemIndex) {
                title = (TextView)this.views.get(itemIndex).findViewById(R.id.bottom_navigation_item_title);
                icon = (ImageView)this.views.get(itemIndex).findViewById(R.id.bottom_navigation_item_icon);
                notification = (TextView)this.views.get(itemIndex).findViewById(R.id.bottom_navigation_notification);
                AHHelper.updateTopMargin((View)icon, inactiveMarginTop, activeMarginTop);
                AHHelper.updateLeftMargin((View)notification, notificationInactiveMarginLeft, notificationActiveMarginLeft);
                AHHelper.updateTextColor(title, itemInactiveColor, itemActiveColor);
                AHHelper.updateTextSize(title, inactiveSize, activeSize);
                AHHelper.updateDrawableColor(this.context, this.items.get(itemIndex).getDrawable(this.context), icon, itemInactiveColor, itemActiveColor, this.forceTint);
                if (Build.VERSION.SDK_INT >= 21 && this.colored) {
                    this.backgroundColorView.setBackgroundColor(this.items.get(itemIndex).getColor(this.context));
                    int finalRadius = Math.max(this.getWidth(), this.getHeight());
                    int cx = (int)this.views.get(itemIndex).getX() + this.views.get(itemIndex).getWidth() / 2;
                    int cy = this.views.get(itemIndex).getHeight() / 2;
                    Animator anim = ViewAnimationUtils.createCircularReveal((View)this.backgroundColorView, (int)cx, (int)cy, (float)0.0f, (float)finalRadius);
                    anim.addListener(new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                        }

                        public void onAnimationEnd(Animator animation) {
                            AHBottomNavigation.this.setBackgroundColor(((AHBottomNavigationItem)AHBottomNavigation.this.items.get(itemIndex)).getColor(AHBottomNavigation.this.context));
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                    anim.start();
                    continue;
                }
                if (this.colored) {
                    AHHelper.updateViewBackgroundColor((View)this, this.currentColor, this.items.get(itemIndex).getColor(this.context));
                    continue;
                }
                this.setBackgroundColor(this.defaultBackgroundColor);
                this.backgroundColorView.setBackgroundColor(0);
                continue;
            }
            if (i != this.currentItem) continue;
            title = (TextView)this.views.get(this.currentItem).findViewById(R.id.bottom_navigation_item_title);
            icon = (ImageView)this.views.get(this.currentItem).findViewById(R.id.bottom_navigation_item_icon);
            notification = (TextView)this.views.get(this.currentItem).findViewById(R.id.bottom_navigation_notification);
            AHHelper.updateTopMargin((View)icon, activeMarginTop, inactiveMarginTop);
            AHHelper.updateLeftMargin((View)notification, notificationActiveMarginLeft, notificationInactiveMarginLeft);
            AHHelper.updateTextColor(title, itemActiveColor, itemInactiveColor);
            AHHelper.updateTextSize(title, activeSize, inactiveSize);
            AHHelper.updateDrawableColor(this.context, this.items.get(this.currentItem).getDrawable(this.context), icon, itemActiveColor, itemInactiveColor, this.forceTint);
        }
        this.currentItem = itemIndex;
        if (this.currentItem > 0 && this.currentItem < this.items.size()) {
            this.currentColor = this.items.get(this.currentItem).getColor(this.context);
        } else if (this.currentItem == -1) {
            this.setBackgroundColor(this.defaultBackgroundColor);
            this.backgroundColorView.setBackgroundColor(0);
        }
        if (this.listener != null && useCallback) {
            this.listener.onTabSelected(itemIndex);
        }
        if (this.tabSelectedListener != null && useCallback) {
            this.tabSelectedListener.onTabSelected(itemIndex, false);
        }
    }

    private void updateSmallItems(final int itemIndex, boolean useCallback) {
        if (this.currentItem == itemIndex) {
            if (this.tabSelectedListener != null && useCallback) {
                this.tabSelectedListener.onTabSelected(itemIndex, true);
            }
            return;
        }
        int activeMarginTop = (int)this.resources.getDimension(R.dimen.bottom_navigation_small_margin_top_active);
        int inactiveMargin = (int)this.resources.getDimension(R.dimen.bottom_navigation_small_margin_top);
        int notificationActiveMarginLeft = (int)this.resources.getDimension(R.dimen.bottom_navigation_notification_margin_left_active);
        int notificationInactiveMarginLeft = (int)this.resources.getDimension(R.dimen.bottom_navigation_notification_margin_left);
        int itemActiveColor = this.colored ? ContextCompat.getColor((Context)this.context, (int)R.color.colorActiveSmall) : this.accentColor;
        int itemInactiveColor = this.colored ? ContextCompat.getColor((Context)this.context, (int)R.color.colorInactiveSmall) : this.inactiveColor;
        for (int i = 0; i < this.views.size(); ++i) {
            TextView notification;
            ImageView icon;
            TextView title;
            FrameLayout container;
            if (i == itemIndex) {
                container = (FrameLayout)this.views.get(itemIndex).findViewById(R.id.bottom_navigation_small_container);
                title = (TextView)this.views.get(itemIndex).findViewById(R.id.bottom_navigation_small_item_title);
                icon = (ImageView)this.views.get(itemIndex).findViewById(R.id.bottom_navigation_small_item_icon);
                notification = (TextView)this.views.get(itemIndex).findViewById(R.id.bottom_navigation_notification);
                AHHelper.updateTopMargin((View)icon, inactiveMargin, activeMarginTop);
                AHHelper.updateLeftMargin((View)notification, notificationInactiveMarginLeft, notificationActiveMarginLeft);
                AHHelper.updateTextColor(title, itemInactiveColor, itemActiveColor);
                AHHelper.updateAlpha((View)title, 0.0f, 1.0f);
                AHHelper.updateWidth((View)container, this.notSelectedItemWidth, this.selectedItemWidth);
                AHHelper.updateDrawableColor(this.context, this.items.get(itemIndex).getDrawable(this.context), icon, itemInactiveColor, itemActiveColor, this.forceTint);
                if (Build.VERSION.SDK_INT >= 21 && this.colored) {
                    this.backgroundColorView.setBackgroundColor(this.items.get(itemIndex).getColor(this.context));
                    int finalRadius = Math.max(this.getWidth(), this.getHeight());
                    int cx = (int)this.views.get(itemIndex).getX() + this.views.get(itemIndex).getWidth() / 2;
                    int cy = this.views.get(itemIndex).getHeight() / 2;
                    Animator anim = ViewAnimationUtils.createCircularReveal((View)this.backgroundColorView, (int)cx, (int)cy, (float)0.0f, (float)finalRadius);
                    anim.addListener(new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                        }

                        public void onAnimationEnd(Animator animation) {
                            AHBottomNavigation.this.setBackgroundColor(((AHBottomNavigationItem)AHBottomNavigation.this.items.get(itemIndex)).getColor(AHBottomNavigation.this.context));
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                    anim.start();
                    continue;
                }
                if (this.colored) {
                    AHHelper.updateViewBackgroundColor((View)this, this.currentColor, this.items.get(itemIndex).getColor(this.context));
                    continue;
                }
                this.setBackgroundColor(this.defaultBackgroundColor);
                this.backgroundColorView.setBackgroundColor(0);
                continue;
            }
            if (i != this.currentItem) continue;
            container = this.views.get(this.currentItem).findViewById(R.id.bottom_navigation_small_container);
            title = (TextView)this.views.get(this.currentItem).findViewById(R.id.bottom_navigation_small_item_title);
            icon = (ImageView)this.views.get(this.currentItem).findViewById(R.id.bottom_navigation_small_item_icon);
            notification = (TextView)this.views.get(this.currentItem).findViewById(R.id.bottom_navigation_notification);
            AHHelper.updateTopMargin((View)icon, activeMarginTop, inactiveMargin);
            AHHelper.updateLeftMargin((View)notification, notificationActiveMarginLeft, notificationInactiveMarginLeft);
            AHHelper.updateTextColor(title, itemActiveColor, itemInactiveColor);
            AHHelper.updateAlpha((View)title, 1.0f, 0.0f);
            AHHelper.updateWidth((View)container, this.selectedItemWidth, this.notSelectedItemWidth);
            AHHelper.updateDrawableColor(this.context, this.items.get(this.currentItem).getDrawable(this.context), icon, itemActiveColor, itemInactiveColor, this.forceTint);
        }
        this.currentItem = itemIndex;
        if (this.currentItem > 0 && this.currentItem < this.items.size()) {
            this.currentColor = this.items.get(this.currentItem).getColor(this.context);
        } else if (this.currentItem == -1) {
            this.setBackgroundColor(this.defaultBackgroundColor);
            this.backgroundColorView.setBackgroundColor(0);
        }
        if (this.listener != null && useCallback) {
            this.listener.onTabSelected(itemIndex);
        }
        if (this.tabSelectedListener != null && useCallback) {
            this.tabSelectedListener.onTabSelected(itemIndex, false);
        }
    }

    private void updateNotifications(boolean updateStyle, int itemPosition) {
        float textSize = this.resources.getDimension(R.dimen.bottom_navigation_notification_text_size);
        float textSizeMin = this.resources.getDimension(R.dimen.bottom_navigation_notification_text_size_min);
        for (int i = 0; i < this.views.size(); ++i) {
            boolean animate;
            if (itemPosition != -1 && itemPosition != i) continue;
            TextView notification = (TextView)this.views.get(i).findViewById(R.id.bottom_navigation_notification);
            String currentValue = notification.getText().toString();
            boolean bl = animate = !currentValue.equals(String.valueOf(this.notifications[i]));
            if (updateStyle) {
                notification.setTextColor(this.notificationTextColor);
                if (this.notificationTypeface != null) {
                    notification.setTypeface(this.notificationTypeface);
                } else {
                    notification.setTypeface(Typeface.DEFAULT);
                }
                if (this.notificationBackgroundDrawable != null) {
                    if (Build.VERSION.SDK_INT >= 16) {
                        notification.setBackground(this.notificationBackgroundDrawable);
                    } else {
                        notification.setBackgroundDrawable(this.notificationBackgroundDrawable);
                    }
                } else if (this.notificationBackgroundColor != 0) {
                    Drawable defautlDrawable = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.notification_background);
                    if (Build.VERSION.SDK_INT >= 16) {
                        notification.setBackground(AHHelper.getTintDrawable(defautlDrawable, this.notificationBackgroundColor, this.forceTint));
                    } else {
                        notification.setBackgroundDrawable(AHHelper.getTintDrawable(defautlDrawable, this.notificationBackgroundColor, this.forceTint));
                    }
                }
            }
            if (this.notifications[i] == 0 && notification.getText().length() > 0) {
                notification.setText((CharSequence)"");
                if (!animate) continue;
                notification.animate().scaleX(0.0f).scaleY(0.0f).alpha(0.0f).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).setDuration(150L).start();
                continue;
            }
            if (this.notifications[i] <= 0) continue;
            if (this.notifications[i] >= 100) {
                notification.setTextSize(0, textSizeMin);
                notification.setText((CharSequence)"99+");
            } else {
                notification.setTextSize(0, textSize);
                notification.setText((CharSequence)String.valueOf(this.notifications[i]));
            }
            if (!animate) continue;
            notification.setScaleX(0.0f);
            notification.setScaleY(0.0f);
            notification.animate().scaleX(1.0f).scaleY(1.0f).alpha(1.0f).setInterpolator((TimeInterpolator)new OvershootInterpolator()).setDuration(150L).start();
        }
    }

    public void addItem(AHBottomNavigationItem item) {
        if (this.items.size() > 5) {
            Log.w((String)TAG, (String)"The items list should not have more than 5 items");
        }
        this.items.add(item);
        this.createItems();
    }

    public void addItems(List<AHBottomNavigationItem> items) {
        if (items.size() > 5 || this.items.size() + items.size() > 5) {
            Log.w((String)TAG, (String)"The items list should not have more than 5 items");
        }
        this.items.addAll(items);
        this.createItems();
    }

    public void removeItemAtIndex(int index) {
        if (index < this.items.size()) {
            this.items.remove(index);
            this.createItems();
        }
    }

    public void removeAllItems() {
        this.items.clear();
        this.createItems();
    }

    public int getItemsCount() {
        return this.items.size();
    }

    public boolean isColored() {
        return this.colored;
    }

    public void setColored(boolean colored) {
        this.colored = colored;
        this.createItems();
    }

    public int getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    public void setDefaultBackgroundColor(@ColorInt int defaultBackgroundColor) {
        this.defaultBackgroundColor = defaultBackgroundColor;
        this.createItems();
    }

    public int getAccentColor() {
        return this.accentColor;
    }

    public void setAccentColor(int accentColor) {
        this.accentColor = accentColor;
        this.createItems();
    }

    public int getInactiveColor() {
        return this.inactiveColor;
    }

    public void setInactiveColor(int inactiveColor) {
        this.inactiveColor = inactiveColor;
        this.createItems();
    }

    public int getCurrentItem() {
        return this.currentItem;
    }

    public void setCurrentItem(int position) {
        this.setCurrentItem(position, true);
    }

    public void setCurrentItem(int position, boolean useCallback) {
        if (position >= this.items.size()) {
            Log.w((String)TAG, (String)("The position is out of bounds of the items (" + this.items.size() + " elements)"));
            return;
        }
        if (this.items.size() == 3 || this.forceTitlesDisplay) {
            this.updateItems(position, useCallback);
        } else {
            this.updateSmallItems(position, useCallback);
        }
    }

    public boolean isBehaviorTranslationEnabled() {
        return this.behaviorTranslationEnabled;
    }

    public void setBehaviorTranslationEnabled(boolean behaviorTranslationEnabled) {
        this.behaviorTranslationEnabled = behaviorTranslationEnabled;
        if (this.getParent() instanceof CoordinatorLayout) {
            ViewGroup.LayoutParams params = this.getLayoutParams();
            this.bottomNavigationBehavior = new AHBottomNavigationBehavior(behaviorTranslationEnabled);
            ((CoordinatorLayout.LayoutParams)params).setBehavior(this.bottomNavigationBehavior);
            if (this.needHideBottomNavigation) {
                this.needHideBottomNavigation = false;
                this.bottomNavigationBehavior.hideView(this, this.bottomNavigationHeight);
            }
        }
    }

    public void hideBottomNavigation() {
        if (this.bottomNavigationBehavior != null) {
            this.bottomNavigationBehavior.hideView(this, this.bottomNavigationHeight);
        } else {
            this.needHideBottomNavigation = true;
        }
    }

    public void restoreBottomNavigation() {
        if (this.bottomNavigationBehavior != null) {
            this.bottomNavigationBehavior.resetOffset(this);
        }
    }

    public boolean isForceTint() {
        return this.forceTint;
    }

    public void setForceTint(boolean forceTint) {
        this.forceTint = forceTint;
        this.createItems();
    }

    public boolean isForceTitlesDisplay() {
        return this.forceTitlesDisplay;
    }

    public void setForceTitlesDisplay(boolean forceTitlesDisplay) {
        this.forceTitlesDisplay = forceTitlesDisplay;
        this.createItems();
    }

    @Deprecated
    public void setAHBottomNavigationListener(AHBottomNavigationListener listener) {
        this.listener = listener;
    }

    @Deprecated
    public void removeAHBottomNavigationListener() {
        this.listener = null;
    }

    public void setOnTabSelectedListener(OnTabSelectedListener tabSelectedListener) {
        this.tabSelectedListener = tabSelectedListener;
    }

    public void removeOnTabSelectedListener() {
        this.tabSelectedListener = null;
    }

    public void setNotification(int nbNotification, int itemPosition) {
        if (itemPosition < 0 || itemPosition > this.items.size() - 1) {
            Log.w((String)TAG, (String)("The position is out of bounds of the items (" + this.items.size() + " elements)"));
            return;
        }
        this.notifications[itemPosition] = nbNotification;
        this.updateNotifications(false, itemPosition);
    }

    public void setNotificationTextColor(@ColorInt int textColor) {
        this.notificationTextColor = textColor;
        this.updateNotifications(true, -1);
    }

    public void setNotificationTextColorResource(@ColorRes int textColor) {
        this.notificationTextColor = ContextCompat.getColor((Context)this.context, (int)textColor);
        this.updateNotifications(true, -1);
    }

    public void setNotificationBackground(Drawable drawable2) {
        this.notificationBackgroundDrawable = drawable2;
        this.updateNotifications(true, -1);
    }

    public void setNotificationBackgroundColor(@ColorInt int color2) {
        this.notificationBackgroundColor = color2;
        this.updateNotifications(true, -1);
    }

    public void setNotificationBackgroundColorResource(@ColorRes int color2) {
        this.notificationBackgroundColor = ContextCompat.getColor((Context)this.context, (int)color2);
        this.updateNotifications(true, -1);
    }

    public void setNotificationBackgroundColorResource(Typeface typeface) {
        this.notificationTypeface = typeface;
        this.updateNotifications(true, -1);
    }

    public void setUseElevation(boolean useElevation) {
        ViewCompat.setElevation((View)this, (float)(useElevation ? this.resources.getDimension(R.dimen.bottom_navigation_elevation) : 0.0f));
        this.setClipToPadding(false);
    }

    public static interface OnTabSelectedListener {
        public void onTabSelected(int var1, boolean var2);
    }

    @Deprecated
    public static interface AHBottomNavigationListener {
        public void onTabSelected(int var1);
    }
}

