/*
 * Decompiled with CFR 0.152.
 */
package com.aurelhubert.ahbottomnavigation;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;

public class AHHelper {
    public static Drawable getTintDrawable(Context context, int drawableResource, int color2) {
        Drawable normalDrawable = ContextCompat.getDrawable((Context)context, (int)drawableResource);
        Drawable wrapDrawable = DrawableCompat.wrap((Drawable)normalDrawable);
        DrawableCompat.setTint((Drawable)wrapDrawable, (int)color2);
        return wrapDrawable;
    }

    public static void updateTopPadding(final View view, int fromPadding, int toPadding) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{fromPadding, toPadding});
        animator.setDuration(150L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float animatedValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                view.setPadding(view.getPaddingLeft(), (int)animatedValue, view.getPaddingRight(), view.getPaddingBottom());
            }
        });
        animator.start();
    }

    public static void updateTextSize(final TextView textView, float fromSize, float toSize) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{fromSize, toSize});
        animator.setDuration(150L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float animatedValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                textView.setTextSize(0, animatedValue);
            }
        });
        animator.start();
    }

    public static void updateAlpha(final View view, float fromValue, float toValue) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{fromValue, toValue});
        animator.setDuration(150L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float animatedValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                view.setAlpha(animatedValue);
            }
        });
        animator.start();
    }

    public static void updateTextColor(final TextView textView, int fromColor, int toColor) {
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{fromColor, toColor});
        colorAnimation.setDuration(150L);
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                textView.setTextColor(((Integer)animator.getAnimatedValue()).intValue());
            }
        });
        colorAnimation.start();
    }

    public static void updateViewBackgroundColor(final View view, int fromColor, int toColor) {
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{fromColor, toColor});
        colorAnimation.setDuration(150L);
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                view.setBackgroundColor(((Integer)animator.getAnimatedValue()).intValue());
            }
        });
        colorAnimation.start();
    }

    public static void updateDrawableColor(final Context context, final int drawable, final ImageView imageView, int fromColor, int toColor) {
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{fromColor, toColor});
        colorAnimation.setDuration(150L);
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                imageView.setImageDrawable(AHHelper.getTintDrawable(context, drawable, (Integer)animator.getAnimatedValue()));
            }
        });
        colorAnimation.start();
    }

    public static void updateWidth(final View view, float fromWidth, float toWidth) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{fromWidth, toWidth});
        animator.setDuration(150L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                ViewGroup.LayoutParams params = view.getLayoutParams();
                params.width = Math.round(((Float)animator.getAnimatedValue()).floatValue());
                view.setLayoutParams(params);
            }
        });
        animator.start();
    }

    public static boolean isTranslucentStatusBar(Context context) {
        Window w = AHHelper.unwrap(context).getWindow();
        WindowManager.LayoutParams lp = w.getAttributes();
        int flags = lp.flags;
        return (flags & 0x8000000) == 0x8000000;
    }

    public static int getSoftButtonsBarSizePort(Context context) {
        if (Build.VERSION.SDK_INT >= 17) {
            DisplayMetrics metrics = new DisplayMetrics();
            Window window = AHHelper.unwrap(context).getWindow();
            window.getWindowManager().getDefaultDisplay().getMetrics(metrics);
            int usableHeight = metrics.heightPixels;
            window.getWindowManager().getDefaultDisplay().getRealMetrics(metrics);
            int realHeight = metrics.heightPixels;
            if (realHeight > usableHeight) {
                return realHeight - usableHeight;
            }
            return 0;
        }
        return 0;
    }

    public static Activity unwrap(Context context) {
        while (!(context instanceof Activity)) {
            ContextWrapper wrapper = (ContextWrapper)context;
            context = wrapper.getBaseContext();
        }
        return (Activity)context;
    }
}

