/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.CoseException;
import COSE.Message;
import COSE.MessageTag;
import COSE.Signer;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.util.ArrayList;
import java.util.List;

public class SignMessage
extends Message {
    protected List<Signer> signerList = new ArrayList<Signer>();
    protected byte[] rgbProtected;

    public SignMessage() {
        this.messageTag = MessageTag.Sign;
    }

    @Override
    protected void DecodeFromCBORObject(CBORObject obj) throws CoseException {
        if (obj.size() != 4) {
            throw new CoseException("Invalid SignMessage structure");
        }
        if (obj.get(0).getType() == CBORType.ByteString) {
            if (obj.get(0).GetByteString().length == 0) {
                this.objProtected = CBORObject.NewMap();
                this.rgbProtected = new byte[0];
            } else {
                this.rgbProtected = obj.get(0).GetByteString();
                this.objProtected = CBORObject.DecodeFromBytes((byte[])this.rgbProtected);
                if (this.objProtected.size() == 0) {
                    this.rgbProtected = new byte[0];
                }
            }
        } else {
            throw new CoseException("Invalid SignMessage structure");
        }
        if (obj.get(1).getType() != CBORType.Map) {
            throw new CoseException("Invalid SignMessage structure");
        }
        this.objUnprotected = obj.get(1);
        if (obj.get(2).getType() == CBORType.ByteString) {
            this.rgbContent = obj.get(2).GetByteString();
        } else if (!obj.get(2).isNull()) {
            throw new CoseException("Invalid SignMessage structure");
        }
        if (obj.get(3).getType() == CBORType.Array) {
            for (int i = 0; i < obj.get(3).size(); ++i) {
                Signer signer = new Signer();
                signer.DecodeFromCBORObject(obj.get(3).get(i));
                this.signerList.add(signer);
            }
        } else {
            throw new CoseException("Invalid SignMessage structure");
        }
    }

    @Override
    protected CBORObject EncodeCBORObject() throws CoseException {
        CBORObject obj = CBORObject.NewArray();
        obj.Add((Object)this.rgbProtected);
        obj.Add(this.objUnprotected);
        obj.Add((Object)this.rgbContent);
        obj.Add(CBORObject.NewArray());
        for (Signer r : this.signerList) {
            obj.get(3).Add(r.EncodeToCBORObject());
        }
        return obj;
    }

    public void AddSigner(Signer signedBy) {
        this.signerList.add(signedBy);
    }

    public Signer getSigner(int iSigner) {
        return this.signerList.get(iSigner);
    }

    public int getSignerCount() {
        return this.signerList.size();
    }

    public List<Signer> getSignerList() {
        return this.signerList;
    }

    public void sign() throws CoseException {
        if (this.rgbProtected == null) {
            this.rgbProtected = this.objProtected.size() == 0 ? new byte[0] : this.objProtected.EncodeToBytes();
        }
        for (Signer r : this.signerList) {
            r.sign(this.rgbProtected, this.rgbContent);
        }
    }

    public boolean validate(Signer signerToUse) throws CoseException {
        for (Signer r : this.signerList) {
            if (r != signerToUse) continue;
            return r.validate(this.rgbProtected, this.rgbContent);
        }
        throw new CoseException("Signer not found");
    }
}

