/*
 * Decompiled with CFR 0.152.
 */
package com.att.ajsc.common.service.rs;

import com.att.ajsc.common.dto.EnterpriseWrapper;
import com.att.ajsc.common.dto.OrderBy;
import com.att.ajsc.common.dto.PagingInfo;
import com.att.ajsc.common.dto.PagingParameters;
import com.att.ajsc.common.dto.SortAttribute;
import com.att.ajsc.common.dto.WhereClause;
import com.att.ajsc.common.exception.ServerErrorException;
import com.att.ajsc.common.service.GenericService;
import com.att.ajsc.common.service.rs.GenericRestService;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.dom4j.tree.AbstractEntity;

public class GenericRestServiceImpl<T>
implements GenericRestService<T> {
    private static Set<String> entityFieldNames = new HashSet<String>();
    protected final GenericService<T> service;

    public GenericRestServiceImpl(GenericService<T> service) {
        this.service = service;
    }

    @PostConstruct
    private void initialize() {
        entityFieldNames = this.getEntityFields();
    }

    @Override
    public T getById(String transactionId, String id) {
        Object entity = null;
        try {
            entity = this.service.getEntityById(id);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage()).getRestException();
        }
        return (T)entity;
    }

    private List<WhereClause> getWhereClauseFromUri(UriInfo uri, List<WhereClause> whereClause) throws BadRequestException {
        if (uri == null) {
            return whereClause;
        }
        MultivaluedMap queryParameters = uri.getQueryParameters();
        for (String queryParameter : queryParameters.keySet()) {
            List queryArguments = (List)queryParameters.get((Object)queryParameter);
            if (queryArguments.size() > 1) {
                throw new BadRequestException("Only one argument per entity parameter allowed");
            }
            if (queryArguments.isEmpty() || !entityFieldNames.contains(queryParameter)) continue;
            this.addWhere(whereClause, queryParameter, "=", (String)queryArguments.get(0));
        }
        return whereClause;
    }

    private List<WhereClause> getWhereClause(UriInfo uri, List<WhereClause> whereClause, String filter) throws BadRequestException {
        if (whereClause == null) {
            whereClause = new ArrayList<WhereClause>();
        }
        this.getWhereClauseFromUri(uri, whereClause);
        this.getWhereClauseFromFilter(filter);
        return whereClause;
    }

    @Override
    public Response getWithFilters(String transactionId, List<String> ids, List<String> select, List<WhereClause> where, String filter, UriInfo allUri, List<OrderBy> orderBy, Integer limit, Integer offset) {
        Response response = null;
        try {
            where = this.getWhereClause(allUri, where, filter);
            PagingParameters pagingParameters = this.getPagingParameters(orderBy, limit, offset);
            EnterpriseWrapper wrapper = this.service.getEntitiesWithFilters(select, where, pagingParameters);
            List entities = wrapper.getEntities();
            PagingInfo pagingInfo = wrapper.getPagingInfo();
            response = Response.status((Response.Status)Response.Status.OK).entity((Object)entities).header("X-ATT-Total-Count", (Object)pagingInfo.getRecordSetTotal()).build();
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage()).getRestException();
        }
        return response;
    }

    private Set<String> getEntityFields() {
        HashSet<String> entityFields = new HashSet<String>();
        ParameterizedType type = (ParameterizedType)this.getClass().getGenericSuperclass();
        Class entityClass = (Class)type.getActualTypeArguments()[0];
        for (Field field : entityClass.getDeclaredFields()) {
            entityFields.add(field.getName());
        }
        for (Field field : AbstractEntity.class.getDeclaredFields()) {
            entityFields.add(field.getName());
        }
        return entityFields;
    }

    private List<WhereClause> getWhereClauseFromFilter(String filter) throws BadRequestException {
        ArrayList<WhereClause> whereClauses = new ArrayList<WhereClause>();
        if (filter == null || filter.isEmpty()) {
            return whereClauses;
        }
        ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        try {
            JsonNode jsonNode = mapper.readTree(filter);
            Map result = (Map)mapper.convertValue((Object)jsonNode, Map.class);
            for (String filterKey : result.keySet()) {
                String fieldName = filterKey.toLowerCase();
                if (!entityFieldNames.contains(fieldName)) {
                    throw new Exception(fieldName + " is not a valid field name for this entity");
                }
                Object value = result.get(filterKey);
                if (value instanceof Map) {
                    Map operatorMap = (Map)value;
                    for (String operatorMapKey : operatorMap.keySet()) {
                        List valueList;
                        String operator = operatorMapKey.toLowerCase();
                        Object operatorValue = operatorMap.get(operatorMapKey);
                        if ("range".equalsIgnoreCase(operator)) {
                            valueList = (List)operatorValue;
                            if (valueList == null || valueList.size() != 2) continue;
                            Double min = (Double)valueList.get(0);
                            Double max = (Double)valueList.get(1);
                            this.addWhere(whereClauses, fieldName, ">=", min.toString());
                            this.addWhere(whereClauses, fieldName, "<=", max.toString());
                            continue;
                        }
                        if (operatorValue instanceof Map) {
                            throw new Exception("and/or not yet supported");
                        }
                        if (operatorValue instanceof List) {
                            valueList = (List)operatorValue;
                            for (String valueFromList : valueList) {
                                this.addWhere(whereClauses, fieldName, operator, valueFromList.toString());
                            }
                            continue;
                        }
                        this.addWhere(whereClauses, fieldName, operator, operatorValue.toString());
                    }
                    continue;
                }
                this.addWhere(whereClauses, fieldName, "eq", value.toString());
            }
        }
        catch (Exception e) {
            String message = "Unable to parse filter query: " + e.getMessage();
            throw new BadRequestException(message);
        }
        return whereClauses;
    }

    private void addWhere(List<WhereClause> whereClauses, String fieldName, String operator, String value) {
        if ("eq".equalsIgnoreCase(operator)) {
            operator = "=";
        } else if ("lt".equalsIgnoreCase(operator)) {
            operator = "<";
        } else if ("gt".equalsIgnoreCase(operator)) {
            operator = ">";
        } else if ("lteq".equalsIgnoreCase(operator)) {
            operator = "<=";
        } else if ("gteq".equalsIgnoreCase(operator)) {
            operator = ">=";
        } else if ("noteq".equalsIgnoreCase(operator)) {
            operator = "!=";
        }
        WhereClause where = new WhereClause(fieldName, operator, value);
        whereClauses.add(where);
    }

    @Override
    public T submit(String transactionId, T entity) {
        try {
            entity = this.service.saveEntity(entity);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage()).getRestException();
        }
        return entity;
    }

    @Override
    public T put(String transactionId, T entity) {
        try {
            entity = this.service.updateEntity(entity);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage()).getRestException();
        }
        return entity;
    }

    @Override
    public T update(String transactionId, T entity) throws Exception {
        return this.put(transactionId, entity);
    }

    @Override
    public void delete(String transactionId, String id) {
        try {
            this.service.deleteEntity(id);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage()).getRestException();
        }
    }

    private PagingParameters getPagingParameters(List<OrderBy> orderBy, Integer limit, Integer offset) {
        PagingParameters params = new PagingParameters();
        params.setFetchSize(limit);
        params.setFetchStart(offset);
        if (orderBy != null && orderBy.size() > 0) {
            ArrayList<SortAttribute> sortAttributes = new ArrayList<SortAttribute>();
            for (OrderBy orderByDTO : orderBy) {
                SortAttribute entry = new SortAttribute();
                entry.setName(orderByDTO.getFieldName());
                entry.setDescending(orderByDTO.isDesc());
                sortAttributes.add(entry);
            }
            params.getSortOrder().addAll(sortAttributes);
        }
        return params;
    }
}

