/*
 * Decompiled with CFR 0.152.
 */
package com.att.ajsc.common.messaging;

import com.att.ajsc.common.Interceptor;
import com.att.ajsc.common.RestMessages;
import com.att.ajsc.common.TransactionTrail;
import com.att.ajsc.logging.AjscEelfManager;
import com.att.eelf.configuration.EELFLogger;
import com.att.eelf.i18n.EELFResolvableErrorEnum;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class TransactionIdResponseFilter
implements ContainerResponseFilter,
ClientResponseFilter {
    public static final String TRANSACTION_ID_KEY = "X-ATT-Transaction-Id";
    private static final String TRANSACTION_TRAIL = "transactionTrail";
    private static final String INTERCEPTOR_ERROR = "interceptorError";
    private static final String RESPONSE = "response";
    private static final String PROMETHEUS = "prometheus";
    private static final String ERROR = "error";
    private static EELFLogger logger = AjscEelfManager.getInstance().getLogger(TransactionIdResponseFilter.class);
    private static final String[] headersToCopy = new String[]{"X-CSI-MethodName", "X-CSI-ServiceName", "X-CSI-REST_NAME_NORMALIZED"};
    @Autowired
    private ApplicationContext context;
    @Autowired
    private Environment environment;
    @Autowired
    private Interceptor interceptor;
    @Context
    private HttpServletRequest request;
    @Context
    private HttpServletResponse response;
    @Value(value="${spring.mvc.urls}")
    private String urlsTOSkip;

    public void filter(Map<String, List<Object>> requestHeaders, Map<String, List<Object>> responseHeaders) throws IOException {
        List<Object> requestTransactionIds;
        List<Object> responseTransactionIds = responseHeaders.get(TRANSACTION_ID_KEY);
        if (responseTransactionIds == null) {
            responseTransactionIds = new ArrayList<Object>();
        }
        if (responseTransactionIds.isEmpty() && (requestTransactionIds = requestHeaders.get(TRANSACTION_ID_KEY)) != null && !requestTransactionIds.isEmpty()) {
            String transactionId = (String)requestTransactionIds.get(0);
            responseTransactionIds.add(transactionId);
            responseHeaders.put(TRANSACTION_ID_KEY, responseTransactionIds);
        }
        for (int i = 0; i < headersToCopy.length; ++i) {
            if (requestHeaders.get(headersToCopy[i]) == null) continue;
            responseHeaders.put(headersToCopy[i], requestHeaders.get(headersToCopy[i]));
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        TransactionTrail transactionTrail;
        MultivaluedMap requestHeaders = requestContext.getHeaders();
        MultivaluedMap responseHeaders = responseContext.getHeaders();
        if (requestContext.getProperty(INTERCEPTOR_ERROR) != null || requestContext.getUriInfo().getPath().equals(PROMETHEUS) || requestContext.getUriInfo().getPath().equals(ERROR)) {
            return;
        }
        this.filter((Map<String, List<Object>>)requestHeaders, (Map<String, List<Object>>)responseHeaders);
        requestContext.setProperty(RESPONSE, (Object)this.response);
        if (StringUtils.isNotEmpty((String)this.urlsTOSkip)) {
            String[] mvcUrls = this.urlsTOSkip.split(",");
            for (int i = 0; i < mvcUrls.length; ++i) {
                if (!requestContext.getUriInfo().getPath().startsWith(mvcUrls[i])) continue;
                return;
            }
        }
        try {
            this.interceptor.filter(requestContext, responseContext, this.environment, this.context);
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error((EELFResolvableErrorEnum)RestMessages.REST_POST_INTERCEPTORS_INVOCATION_ERROR, (Throwable)e, new String[0]);
        }
        if (requestContext.getProperty(TRANSACTION_TRAIL) != null) {
            transactionTrail = (TransactionTrail)requestContext.getProperty(TRANSACTION_TRAIL);
            requestContext.setProperty(INTERCEPTOR_ERROR, (Object)true);
        } else {
            transactionTrail = (TransactionTrail)this.context.getBean(TRANSACTION_TRAIL);
        }
        transactionTrail.setEndTime(System.currentTimeMillis());
        transactionTrail.setTotalTime(transactionTrail.getEndTime() - transactionTrail.getStartTime());
        logger.info((EELFResolvableErrorEnum)RestMessages.REST_TRACE_LOG_MESSAGE, new String[]{transactionTrail.toString()});
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        MultivaluedMap requestHeaders = requestContext.getHeaders();
        MultivaluedMap responseHeaders = responseContext.getHeaders();
        this.filter((Map<String, List<Object>>)requestHeaders, (Map<String, List<Object>>)responseHeaders);
    }
}

