/*
 * Decompiled with CFR 0.152.
 */
package com.att.ajsc.common.messaging;

import com.att.ajsc.common.Interceptor;
import com.att.ajsc.common.RestMessages;
import com.att.ajsc.common.TransactionTrail;
import com.att.ajsc.common.context.CommonContext;
import com.att.ajsc.logging.AjscEelfManager;
import com.att.eelf.configuration.EELFLogger;
import com.att.eelf.i18n.EELFResolvableErrorEnum;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class TransactionIdRequestFilter
implements ContainerRequestFilter,
ClientRequestFilter {
    public static final String TRANSACTION_ID_KEY = "X-ATT-Transaction-Id";
    private static final String TRANSACTION_TRAIL = "transactionTrail";
    private static final String COMMON_CONTEXT = "commonContext";
    private static final String REQUEST = "request";
    private static EELFLogger logger = AjscEelfManager.getInstance().getLogger(TransactionIdRequestFilter.class);
    @Context
    private HttpServletRequest servletRequest;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private Environment environment;
    @Autowired
    private Interceptor interceptor;
    @Value(value="${spring.mvc.urls}")
    private String urlsTOSkip;

    public void filter(Map<String, List<Object>> headers) throws IOException {
        List<Object> transactionIds = headers.get(TRANSACTION_ID_KEY);
        if (transactionIds == null) {
            transactionIds = new ArrayList<Object>();
        }
        if (transactionIds.isEmpty()) {
            String transactionId = UUID.randomUUID().toString();
            transactionIds.add(transactionId);
            headers.put(TRANSACTION_ID_KEY, transactionIds);
        }
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        TransactionTrail transactionTrail = (TransactionTrail)this.context.getBean(TRANSACTION_TRAIL);
        transactionTrail.setStartTime(System.currentTimeMillis());
        MultivaluedMap headers = requestContext.getHeaders();
        this.filter((Map<String, List<Object>>)headers);
        CommonContext commonContext = requestContext.getProperty(COMMON_CONTEXT) != null ? (CommonContext)requestContext.getProperty(COMMON_CONTEXT) : new CommonContext();
        List requestTransactionIds = (List)headers.get(TRANSACTION_ID_KEY);
        commonContext.setTransactionId((String)requestTransactionIds.get(0));
        transactionTrail.setTransactionid((String)requestTransactionIds.get(0));
        requestContext.setProperty(COMMON_CONTEXT, (Object)commonContext);
        requestContext.setProperty(REQUEST, (Object)this.servletRequest);
        if (StringUtils.isNotEmpty((String)this.urlsTOSkip)) {
            String[] mvcUrls = this.urlsTOSkip.split(",");
            for (int i = 0; i < mvcUrls.length; ++i) {
                if (!requestContext.getUriInfo().getPath().startsWith(mvcUrls[i])) continue;
                return;
            }
        }
        try {
            this.interceptor.filter(requestContext, this.environment, this.context);
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error((EELFResolvableErrorEnum)RestMessages.REST_PRE_INTERCEPTORS_INVOCATION_ERROR, (Throwable)e, new String[0]);
        }
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        MultivaluedMap headers = requestContext.getHeaders();
        this.filter((Map<String, List<Object>>)headers);
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public void setServletRequest(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }
}

