/*
 * Decompiled with CFR 0.152.
 */
package com.att.ajsc.common.messaging;

import com.att.ajsc.common.utility.DateUtility;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.MDC;

public class LogResponseFilter
implements ContainerResponseFilter,
ClientResponseFilter {
    public void filter(Map<String, List<Object>> requestHeaders, Map<String, List<Object>> responseHeaders) throws IOException {
        Date responseTimestamp = DateUtility.nowAsDate();
        MDC.put((String)"responseTimestamp", (String)DateUtility.toIsoString((Date)responseTimestamp));
        String requestTimestampString = MDC.get((String)"requestTimestamp");
        Date requestTimestamp = DateUtility.toDate((String)requestTimestampString);
        Long duration = responseTimestamp.getTime() - requestTimestamp.getTime();
        MDC.put((String)"duration", (String)(duration + ""));
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        MultivaluedMap requestHeaders = requestContext.getHeaders();
        MultivaluedMap responseHeaders = responseContext.getHeaders();
        this.filter((Map<String, List<Object>>)requestHeaders, (Map<String, List<Object>>)responseHeaders);
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        MultivaluedMap requestHeaders = requestContext.getHeaders();
        MultivaluedMap responseHeaders = responseContext.getHeaders();
        this.filter((Map<String, List<Object>>)requestHeaders, (Map<String, List<Object>>)responseHeaders);
    }
}

