/*
 * Decompiled with CFR 0.152.
 */
package com.att.ajsc.common.messaging;

import com.att.ajsc.common.utility.DateUtility;
import com.att.ajsc.common.utility.EnvironmentUtility;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogRequestFilter
implements ContainerRequestFilter,
ClientRequestFilter {
    @Autowired
    EnvironmentUtility environmentUtility;

    public void filter(Map<String, List<Object>> headers) throws IOException {
        List<Object> requestTransactionIds;
        MDC.clear();
        MDC.put((String)"hostname", (String)this.environmentUtility.getHostName());
        MDC.put((String)"serviceName", (String)this.environmentUtility.getApplicationName());
        MDC.put((String)"version", (String)this.environmentUtility.getVersion());
        if (StringUtils.isNotEmpty((String)System.getProperty("PID"))) {
            MDC.put((String)"PID", (String)System.getProperty("PID"));
        }
        if ((requestTransactionIds = headers.get("X-ATT-Transaction-Id")) != null && !requestTransactionIds.isEmpty()) {
            String transactionId = (String)requestTransactionIds.get(0);
            MDC.put((String)"transactionId", (String)transactionId);
            if (transactionId == null || transactionId.isEmpty()) {
                MDC.put((String)"transactionId", (String)"null/empty");
            }
        } else {
            MDC.put((String)"transactionId", (String)"not found in headers");
        }
        MDC.put((String)"requestTimestamp", (String)DateUtility.nowAsIsoString());
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        MultivaluedMap headers = requestContext.getHeaders();
        this.filter((Map<String, List<Object>>)headers);
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        MultivaluedMap headers = requestContext.getHeaders();
        this.filter((Map<String, List<Object>>)headers);
    }
}

