/*
 * Decompiled with CFR 0.152.
 */
package com.att.ajsc.common.messaging;

import com.fasterxml.jackson.databind.util.ISO8601Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;

@Provider
public class DateTimeParamConverterProvider
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(Class<T> clazz, Type type, Annotation[] annotations) {
        if (type.equals(Date.class)) {
            return new DateTimeParamConverter();
        }
        return null;
    }

    static class DateTimeParamConverter
    implements ParamConverter<Date> {
        DateTimeParamConverter() {
        }

        public Date fromString(String value) {
            if (value == null) {
                return null;
            }
            try {
                return ISO8601Utils.parse((String)value, (ParsePosition)new ParsePosition(0));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString(Date value) {
            return ISO8601Utils.format((Date)value);
        }
    }
}

