/*
 * Decompiled with CFR 0.152.
 */
package com.att.ajsc.common.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@MappedSuperclass
@Cacheable(value=false)
@ApiModel(value="AbstractEntity", description="The base of all entities")
public abstract class AbstractEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATED", nullable=false, length=11)
    protected Date created;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="LAST_MODIFIED", nullable=false, length=11)
    protected Date lastModified;

    @PrePersist
    private void onInsert() {
        this.lastModified = this.created = new Date();
    }

    @PreUpdate
    private void onUpdate() {
        this.lastModified = new Date();
    }

    @ApiModelProperty(value="Timestamp of the creation of this entity")
    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    @ApiModelProperty(value="Timestamp of the last modification of this entity")
    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }
}

