/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.recovery.fs;

import com.atomikos.icatch.config.Configuration;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.LogException;
import com.atomikos.recovery.LogReadException;
import com.atomikos.recovery.PendingTransactionRecord;
import com.atomikos.recovery.RecoveryLog;
import com.atomikos.recovery.TxState;
import com.atomikos.recovery.fs.Repository;
import java.util.Collection;

public class RecoveryLogImp
implements RecoveryLog {
    private static final Logger LOGGER = LoggerFactory.createLogger(RecoveryLogImp.class);
    private Repository repository;
    private String recoveryDomainName = Configuration.getConfigProperties().getTmUniqueName();

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public Collection<PendingTransactionRecord> getPendingTransactionRecords() throws LogReadException {
        return this.repository.getAllCoordinatorLogEntries();
    }

    public void closing() {
    }

    public Collection<PendingTransactionRecord> getExpiredPendingCommittingTransactionRecordsAt(long time) throws LogReadException {
        Collection<PendingTransactionRecord> allCoordinatorLogEntries = this.repository.findAllCommittingCoordinatorLogEntries();
        return PendingTransactionRecord.collectLineages(r -> r.isLocalRoot(this.recoveryDomainName) && r.expires < time && r.state == TxState.COMMITTING, allCoordinatorLogEntries);
    }

    public Collection<PendingTransactionRecord> getIndoubtTransactionRecords() throws LogReadException {
        Collection<PendingTransactionRecord> allCoordinatorLogEntries = this.repository.getAllCoordinatorLogEntries();
        return PendingTransactionRecord.collectLineages(r -> r.state == TxState.IN_DOUBT, allCoordinatorLogEntries);
    }

    public boolean isActive() {
        return true;
    }

    public void forgetTransactionRecords(Collection<PendingTransactionRecord> coordinators) {
        try {
            for (PendingTransactionRecord entry : coordinators) {
                PendingTransactionRecord terminated = entry.markAsTerminated();
                this.repository.put(terminated.id, terminated);
            }
        }
        catch (Exception e) {
            LOGGER.logDebug("Unexpected exception - ignoring...", (Throwable)e);
        }
    }

    public void recordAsCommitting(String coordinatorId) throws LogException {
        PendingTransactionRecord entry = this.repository.get(coordinatorId);
        PendingTransactionRecord committing = entry.markAsCommitting();
        this.repository.put(committing.id, committing);
    }

    public void forget(String coordinatorId) {
        try {
            PendingTransactionRecord rec = this.repository.get(coordinatorId);
            PendingTransactionRecord terminated = rec.markAsTerminated();
            this.repository.put(terminated.id, terminated);
        }
        catch (Exception e) {
            LOGGER.logDebug("Unexpected exception - ignoring...", (Throwable)e);
        }
    }

    public PendingTransactionRecord get(String coordinatorId) throws LogReadException {
        return this.repository.get(coordinatorId);
    }

    public void closed() {
    }
}

