/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.finitestates;

import com.atomikos.finitestates.FSM;
import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMEnterListener;
import com.atomikos.finitestates.FSMPreEnterListener;
import com.atomikos.finitestates.FSMPreTransitionListener;
import com.atomikos.finitestates.FSMTransitionEvent;
import com.atomikos.finitestates.FSMTransitionListener;
import com.atomikos.recovery.TxState;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class FSMImp
implements FSM {
    private TxState state_ = null;
    private Hashtable<TxState, Set<EventListener>> enterlisteners_ = null;
    private Hashtable<TxState, Set<EventListener>> preenterlisteners_ = null;
    private Hashtable<TxState, Hashtable<TxState, Set<EventListener>>> transitionlisteners_ = null;
    private Hashtable<TxState, Hashtable<TxState, Set<EventListener>>> pretransitionlisteners_ = null;
    private Object eventsource_ = null;
    private Object stateLatch_;

    public FSMImp(TxState initialstate) {
        this(null, initialstate);
        this.eventsource_ = this;
    }

    public FSMImp(Object eventsource, TxState initialstate) {
        this.state_ = initialstate;
        this.enterlisteners_ = new Hashtable();
        this.preenterlisteners_ = new Hashtable();
        this.transitionlisteners_ = new Hashtable();
        this.pretransitionlisteners_ = new Hashtable();
        this.eventsource_ = eventsource;
        this.stateLatch_ = new Object();
    }

    protected synchronized void addEnterListener(Hashtable<TxState, Set<EventListener>> listeners, EventListener lstnr, TxState state) {
        Set<EventListener> lstnrs = listeners.get(state);
        if (lstnrs == null) {
            lstnrs = new HashSet<EventListener>();
        }
        if (!lstnrs.contains(lstnr)) {
            lstnrs.add(lstnr);
        }
        listeners.put(state, lstnrs);
    }

    protected synchronized void addTransitionListener(Hashtable<TxState, Hashtable<TxState, Set<EventListener>>> listeners, EventListener lstnr, TxState from, TxState to) {
        Set<EventListener> tolstnrs;
        Hashtable<Object, Set<EventListener>> lstnrs = listeners.get(from);
        if (lstnrs == null) {
            lstnrs = new Hashtable();
        }
        if ((tolstnrs = lstnrs.get(to)) == null) {
            tolstnrs = new HashSet<EventListener>();
        }
        if (!tolstnrs.contains(lstnr)) {
            tolstnrs.add(lstnr);
        }
        lstnrs.put(to, tolstnrs);
        listeners.put(from, lstnrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(Hashtable<TxState, Set<EventListener>> listeners, TxState state, boolean pre) {
        Set<EventListener> lstnrs = null;
        FSMEnterEvent event = new FSMEnterEvent(this.eventsource_, state);
        FSMImp fSMImp = this;
        synchronized (fSMImp) {
            lstnrs = listeners.get(state);
            if (lstnrs == null) {
                return;
            }
            lstnrs = new HashSet<EventListener>(lstnrs);
        }
        for (EventListener listener : lstnrs) {
            if (pre && listener instanceof FSMPreEnterListener) {
                ((FSMPreEnterListener)listener).preEnter(event);
                continue;
            }
            if (pre || !(listener instanceof FSMEnterListener)) continue;
            ((FSMEnterListener)listener).entered(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(Hashtable<TxState, Hashtable<TxState, Set<EventListener>>> listeners, TxState from, TxState to, boolean pre) {
        FSMTransitionEvent event = new FSMTransitionEvent(this.eventsource_, from, to);
        Hashtable<TxState, Set<EventListener>> lstnrs = null;
        Set<EventListener> tolstnrs = null;
        FSMImp fSMImp = this;
        synchronized (fSMImp) {
            lstnrs = listeners.get(from);
            if (lstnrs == null) {
                return;
            }
            tolstnrs = lstnrs.get(to);
            if (tolstnrs == null) {
                return;
            }
            lstnrs = new Hashtable<TxState, Set<EventListener>>(lstnrs);
            tolstnrs = new HashSet<EventListener>(tolstnrs);
        }
        for (EventListener listener : tolstnrs) {
            if (pre && listener instanceof FSMPreTransitionListener) {
                ((FSMPreTransitionListener)listener).beforeTransition(event);
                continue;
            }
            if (pre || !(listener instanceof FSMTransitionListener)) continue;
            ((FSMTransitionListener)listener).transitionPerformed(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TxState getState() {
        TxState ret = null;
        Object object = this.stateLatch_;
        synchronized (object) {
            ret = this.state_;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStateObject(TxState state) {
        Object object = this.stateLatch_;
        synchronized (object) {
            this.state_ = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(TxState state) throws IllegalStateException {
        TxState oldstate = null;
        FSMImp fSMImp = this;
        synchronized (fSMImp) {
            if (!this.state_.transitionAllowedTo(state)) {
                throw new IllegalStateException("Transition not allowed: " + this.state_ + " to " + state);
            }
            oldstate = this.state_;
            this.notifyListeners(this.preenterlisteners_, state, true);
            this.notifyListeners(this.pretransitionlisteners_, oldstate, state, true);
            this.setStateObject(state);
        }
        this.notifyListeners(this.enterlisteners_, state, false);
        this.notifyListeners(this.transitionlisteners_, oldstate, state, false);
    }

    @Override
    public void addFSMEnterListener(FSMEnterListener lstnr, TxState state) {
        this.addEnterListener(this.enterlisteners_, lstnr, state);
    }

    @Override
    public void addFSMPreEnterListener(FSMPreEnterListener lstnr, TxState state) {
        this.addEnterListener(this.preenterlisteners_, lstnr, state);
    }

    @Override
    public void addFSMTransitionListener(FSMTransitionListener lstnr, TxState from, TxState to) {
        this.addTransitionListener(this.transitionlisteners_, lstnr, from, to);
    }

    @Override
    public void addFSMPreTransitionListener(FSMPreTransitionListener lstnr, TxState from, TxState to) {
        this.addTransitionListener(this.pretransitionlisteners_, lstnr, from, to);
    }
}

