/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.persistence.imp;

import com.atomikos.diagnostics.Console;
import com.atomikos.persistence.LogException;
import com.atomikos.persistence.LogStream;
import com.atomikos.persistence.ObjectLog;
import com.atomikos.persistence.Recoverable;
import com.atomikos.persistence.imp.SystemLogImage;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class StreamObjectLog
implements ObjectLog {
    protected LogStream logstream_;
    protected Hashtable logTable_;
    protected long size_;
    private boolean initialized_ = false;
    protected boolean panic_ = false;
    protected Console console_;
    private long count_;
    private long maxCount_;

    private StreamObjectLog() {
    }

    public StreamObjectLog(LogStream logStream, long l, Console console) {
        this.logstream_ = logStream;
        this.size_ = 0L;
        this.console_ = console;
        this.logTable_ = new Hashtable();
        this.maxCount_ = l;
        this.count_ = 0L;
    }

    private synchronized void writeCheckpoint() throws LogException {
        ++this.count_;
        if (this.count_ >= this.maxCount_) {
            this.logstream_.writeCheckpoint(this.logTable_.elements());
            this.count_ = 0L;
        }
    }

    public synchronized void init() throws LogException {
        Stack<Exception> stack = new Stack<Exception>();
        Vector vector = null;
        if (this.initialized_) {
            return;
        }
        try {
            vector = this.logstream_.recover();
            if (vector != null) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    SystemLogImage systemLogImage = (SystemLogImage)enumeration.nextElement();
                    if (systemLogImage.getId() == null) continue;
                    if (!systemLogImage.isForgettable()) {
                        if (!this.logTable_.containsKey(systemLogImage.getId())) {
                            ++this.size_;
                        }
                        this.logTable_.put(systemLogImage.getId(), systemLogImage);
                        continue;
                    }
                    if (!this.logTable_.containsKey(systemLogImage.getId())) continue;
                    this.logTable_.remove(systemLogImage.getId());
                    --this.size_;
                }
            }
        }
        catch (LogException logException) {
            throw logException;
        }
        catch (Exception exception) {
            stack.push(exception);
            throw new LogException(exception.getMessage(), stack);
        }
        finally {
            this.initialized_ = true;
        }
        this.logstream_.writeCheckpoint(this.logTable_.elements());
    }

    public synchronized Vector recover() throws LogException {
        Stack stack = new Stack();
        Vector<Recoverable> vector = new Vector<Recoverable>();
        if (!this.initialized_) {
            throw new LogException("Not initialized");
        }
        Enumeration enumeration = this.logTable_.elements();
        while (enumeration.hasMoreElements()) {
            SystemLogImage systemLogImage = (SystemLogImage)enumeration.nextElement();
            vector.addElement(systemLogImage.getObjectImage().restore());
        }
        return vector;
    }

    public synchronized void flush(Recoverable recoverable) throws LogException {
        if (recoverable == null) {
            return;
        }
        SystemLogImage systemLogImage = new SystemLogImage(recoverable, false);
        this.flush(systemLogImage);
    }

    protected synchronized void flush(SystemLogImage systemLogImage) throws LogException {
        Stack<Exception> stack = new Stack<Exception>();
        if (systemLogImage == null) {
            return;
        }
        if (this.panic_) {
            throw new LogException("StreamObjectLog: PANIC");
        }
        try {
            try {
                this.logstream_.flushObject(systemLogImage);
                this.writeCheckpoint();
            }
            catch (LogException logException) {
                logException.printStackTrace();
                stack.push(logException);
                try {
                    this.logstream_.writeCheckpoint(this.logTable_.elements());
                }
                catch (Exception exception) {
                    stack.push(exception);
                }
                throw new LogException(logException.getMessage(), stack);
            }
            if (systemLogImage.isForgettable()) {
                if (this.logTable_.containsKey(systemLogImage.getId())) {
                    this.logTable_.remove(systemLogImage.getId());
                    --this.size_;
                }
            } else {
                if (!this.logTable_.containsKey(systemLogImage.getId())) {
                    ++this.size_;
                }
                this.logTable_.put(systemLogImage.getId(), systemLogImage);
            }
        }
        catch (LogException logException) {
            System.err.println("Error in StreamObjectLog.flush() " + logException.getMessage());
            throw logException;
        }
        catch (Exception exception) {
            System.err.println("Error in StreamObjectLog.flush() " + exception.getMessage());
            stack.push(exception);
            throw new LogException(exception.getMessage(), stack);
        }
    }

    public synchronized Recoverable recover(Object object) throws LogException {
        if (!this.logTable_.containsKey(object)) {
            return null;
        }
        SystemLogImage systemLogImage = (SystemLogImage)this.logTable_.get(object);
        return systemLogImage.getObjectImage().restore();
    }

    public synchronized void delete(Object object) throws LogException {
        SystemLogImage systemLogImage = (SystemLogImage)this.logTable_.get(object);
        if (systemLogImage == null) {
            return;
        }
        Recoverable recoverable = systemLogImage.getRecoverable();
        SystemLogImage systemLogImage2 = new SystemLogImage(recoverable, true);
        this.flush(systemLogImage2);
    }

    public synchronized void close() throws LogException {
        Stack<Exception> stack = new Stack<Exception>();
        try {
            if (this.logstream_ != null) {
                this.logstream_.close();
            }
            this.initialized_ = false;
        }
        catch (LogException logException) {
            throw logException;
        }
        catch (Exception exception) {
            stack.push(exception);
            throw new LogException(exception.getMessage(), stack);
        }
    }
}

